/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.config;

import homeostatic.util.ColorHelper;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public class ConfigHandler {
    public static boolean loaded = false;
    public static final WhiteNoiseConfigSpec CLIENT_SPEC;
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Client CLIENT;
    private static final Common COMMON;

    static {
        Pair specPairClient = new WhiteNoiseConfigSpec.Builder().configure(Client::new);
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        CLIENT_SPEC = (WhiteNoiseConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static final class Client {
        private static final List<String> positions = Arrays.asList("TOPLEFT", "TOPCENTER", "TOPRIGHT", "BOTTOMLEFT", "BOTTOMCENTER", "BOTTOMRIGHT");
        private static final List<String> temperatureHudOptions = Arrays.asList("CENTER_GLOBE", "RIGHT_THERMOMETER");
        private static Color temperatureColorCold = ColorHelper.decode("#3ab3da");
        private static Color temperatureColorHot = ColorHelper.decode("#f9801d");
        private static final Predicate<Object> hexRangeValidator = s -> s instanceof String && ((String)s).matches("#[a-zA-Z\\d]{6}->#[a-zA-Z\\d]{6}");
        public final WhiteNoiseConfigSpec.BooleanValue useFahrenheit;
        public final WhiteNoiseConfigSpec.BooleanValue showDegreeSymbol;
        public final WhiteNoiseConfigSpec.ConfigValue<String> debugPosition;
        public final WhiteNoiseConfigSpec.IntValue debugOffsetX;
        public final WhiteNoiseConfigSpec.IntValue debugOffsetY;
        public final WhiteNoiseConfigSpec.DoubleValue scale;
        public final WhiteNoiseConfigSpec.ConfigValue<String> temperatureColorRange;
        public final WhiteNoiseConfigSpec.ConfigValue<String> temperatureHudOption;
        public final WhiteNoiseConfigSpec.ConfigValue<String> thermometerPosition;
        public final WhiteNoiseConfigSpec.IntValue thermometerOffsetX;
        public final WhiteNoiseConfigSpec.IntValue thermometerOffsetY;
        public final WhiteNoiseConfigSpec.IntValue thermometerTextOffsetY;
        public final WhiteNoiseConfigSpec.BooleanValue showThermometerRateChangeSymbols;
        public final WhiteNoiseConfigSpec.ConfigValue<String> globePosition;
        public final WhiteNoiseConfigSpec.IntValue globeOffsetX;
        public final WhiteNoiseConfigSpec.IntValue globeOffsetY;
        public final WhiteNoiseConfigSpec.IntValue globeTextOffsetY;
        public final WhiteNoiseConfigSpec.BooleanValue forceWaterBarPosition;
        public final WhiteNoiseConfigSpec.ConfigValue<String> waterBarPosition;
        public final WhiteNoiseConfigSpec.IntValue waterBarOffsetX;
        public final WhiteNoiseConfigSpec.IntValue waterBarOffsetY;

        Client(WhiteNoiseConfigSpec.Builder builder) {
            this.useFahrenheit = builder.comment("Use Fahrenheit, otherwise use Celcius.").define("useFahrenheit", true);
            this.showDegreeSymbol = builder.comment("Show degree symbol next to temperature value.").define("showDegreeSymbol", true);
            this.debugPosition = builder.comment("Position of debug info, one of: " + String.valueOf(positions)).defineInList("position", (Object)"TOPRIGHT", positions);
            this.debugOffsetX = builder.comment("Debug text X offset").defineInRange("debugOffsetX", 3, -100, 100);
            this.debugOffsetY = builder.comment("Debug text Y offset").defineInRange("debugOffsetY", 3, -100, 100);
            this.scale = builder.comment("The size of the text info (multiplier)").defineInRange("scale", 0.5, 0.5, 2.0);
            this.temperatureColorRange = builder.comment("Temperature color range (Format (cold->hot): #3ab3da->#f9801d)").define("temperatureColorRange", (Object)"#3ab3da->#f9801d", hexRangeValidator);
            this.temperatureHudOption = builder.comment("Select which hud element to display for body and area temperature. One of: " + String.valueOf(temperatureHudOptions)).defineInList("temperatureHudOption", (Object)"CENTER_GLOBE", temperatureHudOptions);
            this.thermometerPosition = builder.comment("Position of the RIGHT_THERMOMETER HUD if enabled, one of: " + String.valueOf(positions)).defineInList("thermometerPosition", (Object)"BOTTOMRIGHT", positions);
            this.thermometerOffsetX = builder.comment("RIGHT_THERMOMETER HUD X offset").defineInRange("thermometerOffsetX", 133, -500, 500);
            this.thermometerOffsetY = builder.comment("RIGHT_THERMOMETER HUD Y offset").defineInRange("thermometerOffsetY", 27, -500, 500);
            this.thermometerTextOffsetY = builder.comment("RIGHT_THERMOMETER HUD Y offset").defineInRange("thermometerTextOffsetY", 15, -500, 500);
            this.showThermometerRateChangeSymbols = builder.comment("Show rate change symbols to left/right of thermometer. Left is core temp, right is skin temperature.").define("showThermometerRateChangeSymbols", true);
            this.globePosition = builder.comment("Position of the CENTER_GLOBE HUD if enabled, one of: " + String.valueOf(positions)).defineInList("globePosition", (Object)"BOTTOMCENTER", positions);
            this.globeOffsetX = builder.comment("CENTER_GLOBE HUD X offset").defineInRange("globeOffsetX", 0, -500, 500);
            this.globeOffsetY = builder.comment("CENTER_GLOBE HUD Y offset").defineInRange("globeOffsetY", 50, -500, 500);
            this.globeTextOffsetY = builder.comment("CENTER_GLOBE HUD Y offset").defineInRange("globeTextOffsetY", 90, -500, 500);
            this.forceWaterBarPosition = builder.comment("Set to true to force position of the water bar.").define("forceWaterBarPosition", false);
            this.waterBarPosition = builder.comment("Position of the Water Bar HUD if forceWaterBarPosition is true, one of: " + String.valueOf(positions)).defineInList("waterBarPosition", (Object)"BOTTOMCENTER", positions);
            this.waterBarOffsetX = builder.comment("Water Bar HUD X offset").defineInRange("waterBarOffsetX", 96, -500, 500);
            this.waterBarOffsetY = builder.comment("Water Bar HUD Y offset").defineInRange("waterBarOffsetY", 50, -500, 500);
        }

        public static boolean useFahrenheit() {
            return (Boolean)ConfigHandler.CLIENT.useFahrenheit.get();
        }

        public static boolean showDegreeSymbol() {
            return (Boolean)ConfigHandler.CLIENT.showDegreeSymbol.get();
        }

        public static String debugPosition() {
            return (String)ConfigHandler.CLIENT.debugPosition.get();
        }

        public static int debugOffsetX() {
            return (Integer)ConfigHandler.CLIENT.debugOffsetX.get();
        }

        public static int debugOffsetY() {
            return (Integer)ConfigHandler.CLIENT.debugOffsetY.get();
        }

        public static double scale() {
            return (Double)ConfigHandler.CLIENT.scale.get();
        }

        public static Color temperatureColorCold() {
            return temperatureColorCold;
        }

        public static Color temperatureColorHot() {
            return temperatureColorHot;
        }

        public static String temperatureHudOption() {
            return (String)ConfigHandler.CLIENT.temperatureHudOption.get();
        }

        public static String thermometerPosition() {
            return (String)ConfigHandler.CLIENT.thermometerPosition.get();
        }

        public static int thermometerOffsetX() {
            return (Integer)ConfigHandler.CLIENT.thermometerOffsetX.get();
        }

        public static int thermometerOffsetY() {
            return (Integer)ConfigHandler.CLIENT.thermometerOffsetY.get();
        }

        public static int thermometerTextOffsetY() {
            return (Integer)ConfigHandler.CLIENT.thermometerTextOffsetY.get();
        }

        public static boolean showThermometerRateChangeSymbols() {
            return (Boolean)ConfigHandler.CLIENT.showThermometerRateChangeSymbols.get();
        }

        public static String globePosition() {
            return (String)ConfigHandler.CLIENT.globePosition.get();
        }

        public static int globeOffsetX() {
            return (Integer)ConfigHandler.CLIENT.globeOffsetX.get();
        }

        public static int globeOffsetY() {
            return (Integer)ConfigHandler.CLIENT.globeOffsetY.get();
        }

        public static int globeTextOffsetY() {
            return (Integer)ConfigHandler.CLIENT.globeTextOffsetY.get();
        }

        public static boolean forceWaterBarPosition() {
            return (Boolean)ConfigHandler.CLIENT.forceWaterBarPosition.get();
        }

        public static String waterBarPosition() {
            return (String)ConfigHandler.CLIENT.waterBarPosition.get();
        }

        public static int waterBarOffsetX() {
            return (Integer)ConfigHandler.CLIENT.waterBarOffsetX.get();
        }

        public static int waterBarOffsetY() {
            return (Integer)ConfigHandler.CLIENT.waterBarOffsetY.get();
        }

        public static void init() {
            String[] temperatureColors = ((String)ConfigHandler.CLIENT.temperatureColorRange.get()).split("->");
            temperatureColorCold = ColorHelper.decode(temperatureColors[0]);
            temperatureColorHot = ColorHelper.decode(temperatureColors[1]);
            loaded = true;
        }
    }

    public static final class Common {
        public final WhiteNoiseConfigSpec.BooleanValue debugEnabled;
        public final WhiteNoiseConfigSpec.BooleanValue showTemperatureValues;
        public final WhiteNoiseConfigSpec.BooleanValue requireThermometer;
        public final WhiteNoiseConfigSpec.DoubleValue randomWaterLoss;
        public final WhiteNoiseConfigSpec.DoubleValue radiationReductionPercent;

        Common(WhiteNoiseConfigSpec.Builder builder) {
            this.debugEnabled = builder.comment("Show temperature debug info.").define("debugEnabled", false);
            this.showTemperatureValues = builder.comment("Show temperature values in HUD.").define("showTemperatureValues", true);
            this.requireThermometer = builder.comment("Require thermometer helmet enhancement to display temperature values.").define("requireThermometer", false);
            this.randomWaterLoss = builder.comment("Water loss speed when not sweating. Increase to make water loss more prevalent.").defineInRange("randomWaterLoss", 0.15, 0.01, 1.0);
            this.radiationReductionPercent = builder.comment("Percentage of radiation reduced when 'Radiation Protection' is added to an armor piece. For example, 0.25 with four pieces will be 100%. 1.0 will be 100% for one piece. Default gives 80% for four pieces.").defineInRange("radiationReductionPercent", 0.2, 0.1, 1.0);
        }

        public static boolean debugEnabled() {
            return (Boolean)ConfigHandler.COMMON.debugEnabled.get();
        }

        public static boolean showTemperatureValues() {
            return (Boolean)ConfigHandler.COMMON.showTemperatureValues.get();
        }

        public static boolean requireThermometer() {
            return (Boolean)ConfigHandler.COMMON.requireThermometer.get();
        }

        public static float getRandomWaterLoss() {
            double waterLoss = (Double)ConfigHandler.COMMON.randomWaterLoss.get();
            return (float)waterLoss;
        }

        public static float getRadiationReductionPercent() {
            double reduction = (Double)ConfigHandler.COMMON.radiationReductionPercent.get();
            return (float)reduction;
        }
    }
}

