/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import homeostatic.common.damagesource.HomeostaticDamageTypes;
import homeostatic.data.HomeostaticDamageTypeTagsProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;

public class RegistryDataGenerator
extends DatapackBuiltinEntriesProvider {
    public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, HomeostaticDamageTypes::bootstrap);

    private RegistryDataGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider, BUILDER, Set.of("minecraft", "homeostatic"));
    }

    public static void addProviders(boolean isServer, DataGenerator gen, PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        gen.addProvider(isServer, (DataProvider)new RegistryDataGenerator(output, provider));
        gen.addProvider(isServer, (DataProvider)new HomeostaticDamageTypeTagsProvider(output, (CompletableFuture<HolderLookup.Provider>)provider.thenApply(r -> RegistryDataGenerator.append(r, BUILDER)), helper));
    }

    private static HolderLookup.Provider append(HolderLookup.Provider original, RegistrySetBuilder builder) {
        HashSet builderKeys = new HashSet(builder.getEntryKeys());
        Cloner.Factory factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().filter(data -> !builderKeys.contains(data.key())).forEach(data -> builder.add(data.key(), context -> {}));
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)factory).addCodec(arg_0, arg_1)));
        return builder.buildPatch((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY), original, factory).full();
    }
}

