/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.temperature.BodyTemperature;
import homeostatic.network.Temperature;
import homeostatic.network.TemperatureData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public class NeoForgeTemperatureData
extends Temperature
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<NeoForgeTemperatureData> TYPE = new CustomPacketPayload.Type(TemperatureData.ID);
    public static final StreamCodec<FriendlyByteBuf, NeoForgeTemperatureData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, NeoForgeTemperatureData::getData, NeoForgeTemperatureData::new);
    private final TemperatureData temperatureData;
    private final CompoundTag data;

    public NeoForgeTemperatureData(float localTemperature, BodyTemperature bodyTemperature) {
        this.temperatureData = new TemperatureData(localTemperature, bodyTemperature.getSkinTemperature(), bodyTemperature.getCoreTemperature());
        this.setLocalTemperature(this.temperatureData.localTemperature);
        this.setSkinTemperature(this.temperatureData.skinTemperature);
        this.setCoreTemperature(this.temperatureData.coreTemperature);
        this.data = this.write(new CompoundTag());
    }

    public NeoForgeTemperatureData(CompoundTag tag) {
        this.read(tag);
        this.data = this.write(new CompoundTag());
        this.temperatureData = new TemperatureData(this.getLocalTemperature(), this.getSkinTemperature(), this.getCoreTemperature());
    }

    public TemperatureData getTemperatureData() {
        return this.temperatureData;
    }

    public CompoundTag getData() {
        return this.data;
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

