/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import homeostatic.Homeostatic;
import homeostatic.common.temperature.TemperatureThreshold;
import homeostatic.overlay.Overlay;
import homeostatic.platform.Services;
import homeostatic.util.OverlayHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class EnhancedVisualsOverlay
extends Overlay {
    public static final ResourceLocation BURNING_OVERLAY = Homeostatic.prefix("textures/gui/burning.png");
    public static final ResourceLocation HYPERTHERMIA_OVERLAY = Homeostatic.prefix("textures/gui/hyperthermia.png");

    @Override
    public void render(GuiGraphics guiGraphics, Minecraft mc, @Nullable BlockPos pos, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        RenderSystem.enableBlend();
        Services.PLATFORM.getTemperatureData((Player)player).ifPresent(data -> {
            float alpha;
            if (data.getSkinTemperature() > TemperatureThreshold.SCALDING_WARNING.temperature) {
                alpha = 0.1f + (data.getSkinTemperature() - TemperatureThreshold.SCALDING_WARNING.temperature) * 10.0f;
                OverlayHelper.renderTexture(BURNING_OVERLAY, scaledWidth, scaledHeight, alpha);
            }
            if (data.getCoreTemperature() > TemperatureThreshold.WARNING_HIGH.temperature) {
                alpha = 0.1f + (data.getCoreTemperature() - TemperatureThreshold.WARNING_HIGH.temperature) * 10.0f;
                OverlayHelper.renderTexture(HYPERTHERMIA_OVERLAY, scaledWidth, scaledHeight, alpha);
            }
        });
    }
}

