/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import homeostatic.Homeostatic;
import homeostatic.common.biome.BiomeCategoryManager;
import homeostatic.common.biome.BiomeTypeData;
import homeostatic.common.biome.BiomeTypeDataManager;
import homeostatic.common.temperature.TemperatureDirection;
import homeostatic.common.temperature.TemperatureRange;
import homeostatic.config.ConfigHandler;
import homeostatic.overlay.Overlay;
import homeostatic.platform.Services;
import homeostatic.util.Alignment;
import homeostatic.util.ColorHelper;
import homeostatic.util.FontHelper;
import homeostatic.util.TempHelper;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;

public class TemperatureInfo
extends Overlay {
    @Override
    public void render(GuiGraphics guiGraphics, Minecraft mc, BlockPos pos, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.player;
        Holder biome = Objects.requireNonNull(mc.level).getBiome(pos);
        if (player == null) {
            return;
        }
        Services.PLATFORM.getTemperatureData((Player)player).ifPresent(data -> {
            TemperatureDirection skinTemperatureDirection = TempHelper.getSkinTemperatureDirection(data.getLocalTemperature(), data.getSkinTemperature());
            TemperatureDirection coreTemperatureDirection = TempHelper.getCoreTemperatureDirection(data.getLastSkinTemperature(), data.getCoreTemperature(), data.getSkinTemperature());
            String skinIcon = skinTemperatureDirection.icon;
            String coreIcon = coreTemperatureDirection.icon;
            String localTemp = String.format(" %.2f", TempHelper.convertMcTemp(data.getLocalTemperature(), ConfigHandler.Client.useFahrenheit()));
            String skinTemp = String.format("s: %.2f%s", TempHelper.convertMcTemp(data.getSkinTemperature(), ConfigHandler.Client.useFahrenheit()), skinIcon);
            String coreTemp = String.format(" c: %.2f%s ", TempHelper.convertMcTemp(data.getCoreTemperature(), ConfigHandler.Client.useFahrenheit()), coreIcon);
            Tuple<TemperatureRange, Integer> localRangeStep = TempHelper.getLocalTemperatureRangeStep(data.getLocalTemperature());
            Tuple<TemperatureRange, Integer> coreRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getCoreTemperature());
            Tuple<TemperatureRange, Integer> skinRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getSkinTemperature());
            int localTempWidth = mc.font.width(localTemp);
            int skinTempWidth = mc.font.width(skinTemp);
            int coreTempWidth = mc.font.width(coreTemp);
            String string = ConfigHandler.Client.debugPosition();
            Objects.requireNonNull(mc.font);
            int y = Alignment.getTextY(string, scaledHeight, 1, 9, ConfigHandler.Client.debugOffsetY(), 1.0f);
            FontHelper.draw(mc, guiGraphics, localTemp, Alignment.getTextX(ConfigHandler.Client.debugPosition(), scaledWidth, localTempWidth, ConfigHandler.Client.debugOffsetX(), 1.0f), y, ColorHelper.getLocalTemperatureColor(localRangeStep), false);
            int n = Alignment.getTextX(ConfigHandler.Client.debugPosition(), scaledWidth, skinTempWidth, ConfigHandler.Client.debugOffsetX(), 1.0f);
            Objects.requireNonNull(mc.font);
            FontHelper.draw(mc, guiGraphics, skinTemp, n, y + 9, ColorHelper.getTemperatureColor(skinRangeStep), false);
            int n2 = Alignment.getTextX(ConfigHandler.Client.debugPosition(), scaledWidth, coreTempWidth, ConfigHandler.Client.debugOffsetX(), 1.0f);
            Objects.requireNonNull(mc.font);
            FontHelper.draw(mc, guiGraphics, coreTemp, n2, y + 9 * 2, ColorHelper.getTemperatureColor(coreRangeStep), false);
            biome.unwrapKey().ifPresent(key -> {
                ResourceLocation biomeCategory = Homeostatic.prefix(BiomeCategoryManager.getBiomeCategory((Holder<Biome>)biome).toString());
                BiomeTypeData biomeTypeData = BiomeTypeDataManager.getBiomeData(biomeCategory);
                String biomeString = String.format("%s (%s) frozen: %s", key.location(), biomeCategory, biomeTypeData.isFrozen());
                int biomeStringWidth = mc.font.width(biomeString);
                int n = Alignment.getTextX(ConfigHandler.Client.debugPosition(), scaledWidth, biomeStringWidth, ConfigHandler.Client.debugOffsetX(), 1.0f);
                Objects.requireNonNull(mc.font);
                FontHelper.draw(mc, guiGraphics, biomeString, n, y + 9 * 3, -1, false);
            });
        });
    }
}

