/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.Homeostatic;
import homeostatic.common.temperature.TemperatureDirection;
import homeostatic.common.temperature.TemperatureRange;
import homeostatic.common.temperature.TemperatureThreshold;
import homeostatic.config.ConfigHandler;
import homeostatic.network.ITemperature;
import homeostatic.overlay.Overlay;
import homeostatic.platform.Services;
import homeostatic.util.Alignment;
import homeostatic.util.ColorHelper;
import homeostatic.util.FontHelper;
import homeostatic.util.TempHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class TemperatureOverlay
extends Overlay {
    public static final ResourceLocation SPRITE = Homeostatic.prefix("textures/gui/icons.png");
    protected static final int ICON_WIDTH = 13;
    protected static final int ICON_HEIGHT = 26;

    @Override
    public void render(GuiGraphics guiGraphics, Minecraft mc, @Nullable BlockPos pos, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.player;
        PoseStack matrix = guiGraphics.pose();
        if (player == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SPRITE);
        Services.PLATFORM.getTemperatureData((Player)player).ifPresent(arg_0 -> this.lambda$render$1(scaledWidth, scaledHeight, mc, guiGraphics, (Player)player, matrix, arg_0));
    }

    private int getTempLineOffset(Tuple<TemperatureRange, Integer> rangeStep) {
        TemperatureRange range = (TemperatureRange)((Object)rangeStep.getA());
        int step = (Integer)rangeStep.getB() / 2;
        int offset = range == TemperatureRange.COLD ? Math.max(7 - step, 1) : Math.min(8 + step, 15);
        return offset;
    }

    private /* synthetic */ void lambda$render$1(int scaledWidth, int scaledHeight, Minecraft mc, GuiGraphics guiGraphics, Player player, PoseStack matrix, ITemperature data) {
        int offsetX = Alignment.getX(ConfigHandler.Client.thermometerPosition(), scaledWidth, 13, ConfigHandler.Client.thermometerOffsetX());
        int pY = Alignment.getY(ConfigHandler.Client.thermometerPosition(), scaledHeight, ConfigHandler.Client.thermometerOffsetY());
        float textScale = 0.5f;
        TemperatureDirection coreTemperatureDirection = TempHelper.getCoreTemperatureDirection(data.getLastSkinTemperature(), data.getCoreTemperature(), data.getSkinTemperature());
        TemperatureDirection skinTemperatureDirection = TempHelper.getSkinTemperatureDirection(data.getLocalTemperature(), data.getSkinTemperature());
        String coreDirection = coreTemperatureDirection.icon;
        String skinDirection = skinTemperatureDirection.icon;
        String coreTempFormat = ConfigHandler.Client.showDegreeSymbol() ? "%.1f\u00b0" : "%.1f";
        String localTempFormat = ConfigHandler.Client.showDegreeSymbol() ? "%.0f\u00b0" : "%.0f";
        String coreTempSmall = String.format(coreTempFormat, TempHelper.convertMcTemp(data.getCoreTemperature(), ConfigHandler.Client.useFahrenheit()));
        String localTemp = String.format(localTempFormat, TempHelper.convertMcTemp(data.getLocalTemperature(), ConfigHandler.Client.useFahrenheit()));
        int textOffsetX = Alignment.getIconTextX(ConfigHandler.Client.thermometerPosition(), scaledWidth, mc.font.width(coreTempSmall), ConfigHandler.Client.thermometerOffsetX(), textScale, 13);
        int localTextOffsetX = Alignment.getIconTextX(ConfigHandler.Client.thermometerPosition(), scaledWidth, mc.font.width(localTemp), ConfigHandler.Client.thermometerOffsetX(), textScale, 13);
        int textOffsetY = Alignment.getIconTextY(ConfigHandler.Client.thermometerPosition(), scaledHeight, ConfigHandler.Client.thermometerTextOffsetY(), textScale);
        int directionOffsetX = Alignment.getIconTextX(ConfigHandler.Client.thermometerPosition(), scaledWidth, mc.font.width(coreDirection), ConfigHandler.Client.thermometerOffsetX(), textScale, 13);
        int pV = 0;
        int pUOffset = 53;
        Tuple<TemperatureRange, Integer> localRangeStep = TempHelper.getLocalTemperatureRangeStep(data.getLocalTemperature());
        Tuple<TemperatureRange, Integer> coreRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getCoreTemperature());
        Tuple<TemperatureRange, Integer> skinRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getSkinTemperature());
        int lineOffset = this.getTempLineOffset(coreRangeStep);
        AtomicBoolean showTemperature = new AtomicBoolean(ConfigHandler.Common.showTemperatureValues());
        if (data.getCoreTemperature() > TemperatureThreshold.WARNING_HIGH.temperature) {
            guiGraphics.blit(SPRITE, offsetX, pY, pUOffset, pV + 26, 13, 26);
        } else if (data.getCoreTemperature() < TemperatureThreshold.WARNING_LOW.temperature) {
            guiGraphics.blit(SPRITE, offsetX, pY, pUOffset, pV + 52, 13, 26);
        } else {
            guiGraphics.blit(SPRITE, offsetX, pY, pUOffset, pV, 13, 26);
        }
        guiGraphics.blit(SPRITE, offsetX, pY, pUOffset + 13, pV + lineOffset, 13, 26);
        if (ConfigHandler.Common.requireThermometer()) {
            Services.PLATFORM.getThermometerCapability(player).ifPresent(thermometer -> showTemperature.set(thermometer.hasThermometer()));
        }
        matrix.scale(textScale, textScale, textScale);
        if (ConfigHandler.Client.showThermometerRateChangeSymbols()) {
            FontHelper.draw(mc, guiGraphics, coreDirection, directionOffsetX - 8, textOffsetY - 15, ColorHelper.getLocalTemperatureColor(coreRangeStep), true);
            FontHelper.draw(mc, guiGraphics, skinDirection, directionOffsetX + 8, textOffsetY - 15, ColorHelper.getLocalTemperatureColor(skinRangeStep), true);
        }
        if (showTemperature.get()) {
            FontHelper.draw(mc, guiGraphics, localTemp, localTextOffsetX, textOffsetY - 50, ColorHelper.getLocalTemperatureColor(localRangeStep), true);
            FontHelper.draw(mc, guiGraphics, coreTempSmall, textOffsetX, textOffsetY, ColorHelper.getTemperatureColor(coreRangeStep), true);
        }
    }
}

