/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.fluid;

import homeostatic.common.TagManager;
import homeostatic.common.block.HomeostaticBlocks;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.HomeostaticItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public abstract class PurifiedWater
extends FlowingFluid {
    public Fluid getFlowing() {
        return HomeostaticFluids.PURIFIED_WATER_FLOWING;
    }

    public Fluid getSource() {
        return HomeostaticFluids.PURIFIED_WATER;
    }

    public Item getBucket() {
        return HomeostaticItems.PURIFIED_WATER_BUCKET;
    }

    protected boolean canConvertToSource(Level level) {
        return false;
    }

    public BlockState createLegacyBlock(FluidState fluidState) {
        return (BlockState)HomeostaticBlocks.PURIFIED_WATER_FLUID.defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(PurifiedWater.getLegacyLevel((FluidState)fluidState)));
    }

    public boolean isSame(Fluid fluid) {
        return fluid == HomeostaticFluids.PURIFIED_WATER || fluid == HomeostaticFluids.PURIFIED_WATER_FLOWING;
    }

    public boolean canBeReplacedWith(FluidState fluidState, BlockGetter blockGetter, BlockPos blockPos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.is(TagManager.Fluids.PURIFIED_WATER);
    }

    protected void beforeDestroyingBlock(LevelAccessor $$0, BlockPos $$1, BlockState $$2) {
        BlockEntity $$3 = $$2.hasBlockEntity() ? $$0.getBlockEntity($$1) : null;
        Block.dropResources((BlockState)$$2, (LevelAccessor)$$0, (BlockPos)$$1, (BlockEntity)$$3);
    }

    public int getSlopeFindDistance(LevelReader $$0) {
        return 4;
    }

    public int getDropOff(LevelReader $$0) {
        return 1;
    }

    public int getTickDelay(LevelReader $$0) {
        return 5;
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL);
    }

    public static class Source
    extends PurifiedWater {
        public boolean isSource(FluidState fluidState) {
            return true;
        }

        public int getAmount(FluidState fluidState) {
            return 8;
        }
    }

    public static class Flowing
    extends PurifiedWater {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> $$0) {
            super.createFluidStateDefinition($$0);
            $$0.add(new Property[]{LEVEL});
        }

        public boolean isSource(FluidState fluidState) {
            return false;
        }

        public int getAmount(FluidState fluidState) {
            return (Integer)fluidState.getValue((Property)LEVEL);
        }
    }
}

