/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.TagManager;
import homeostatic.common.item.DrinkableItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class DrinkableItemManager
extends SimpleJsonResourceReloadListener {
    private static final Map<Item, DrinkableItem> ITEMS = new HashMap<Item, DrinkableItem>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DrinkableItem.class, (Object)new DrinkableItem.Serializer()).create();
    private static final DrinkableItem FRUIT = new DrinkableItem(TagManager.Items.FRUITS.location(), 2, 0.6f, 0, 0, 0.0f);
    private static final DrinkableItem ROOT_VEGETABLE = new DrinkableItem(TagManager.Items.ROOT_VEGETABLES.location(), 1, 0.1f, 0, 0, 0.0f);
    private static final DrinkableItem VEGETABLE = new DrinkableItem(TagManager.Items.VEGETABLES.location(), 1, 0.1f, 0, 0, 0.0f);

    public DrinkableItemManager() {
        super(GSON, "environment/drinkable");
    }

    public static JsonElement parseDrinkableItem(DrinkableItem drinkableItem) {
        return GSON.toJsonTree((Object)drinkableItem);
    }

    public static DrinkableItem get(ItemStack stack) {
        DrinkableItem drinkableItem = ITEMS.get(stack.getItem());
        if (drinkableItem != null) {
            return drinkableItem;
        }
        if (stack.is(TagManager.Items.FRUITS)) {
            return FRUIT;
        }
        if (stack.is(TagManager.Items.ROOT_VEGETABLES)) {
            return ROOT_VEGETABLE;
        }
        if (stack.is(TagManager.Items.VEGETABLES)) {
            return VEGETABLE;
        }
        return null;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        ITEMS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            try {
                DrinkableItem drinkableItem = (DrinkableItem)GSON.fromJson(entry.getValue(), DrinkableItem.class);
                Item item = (Item)BuiltInRegistries.ITEM.get(drinkableItem.loc());
                if (item == Items.AIR) continue;
                ITEMS.put(item, drinkableItem);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse drinkable item {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} drinkable items", (Object)ITEMS.size());
    }
}

