/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.damagesource.HomeostaticDamageTypes;
import homeostatic.common.water.WaterInfo;
import homeostatic.network.IWater;
import homeostatic.util.DamageHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;

public class Water
implements IWater {
    private int waterLevel = 20;
    private float waterSaturationLevel = 5.0f;
    private float waterExhaustionLevel = 0.0f;

    @Override
    public void setWaterLevel(int waterLevel) {
        this.waterLevel = waterLevel;
    }

    @Override
    public void increaseWaterLevel(int level) {
        this.waterLevel = Math.min(this.waterLevel + level, 20);
    }

    @Override
    public void increaseSaturationLevel(float level) {
        this.waterSaturationLevel = Math.min(this.waterSaturationLevel + level, 5.0f);
    }

    @Override
    public void setWaterSaturationLevel(float waterSaturationLevel) {
        this.waterSaturationLevel = waterSaturationLevel;
    }

    @Override
    public void setWaterExhaustionLevel(float waterExhaustionLevel) {
        this.waterExhaustionLevel = waterExhaustionLevel;
    }

    @Override
    public void setWaterData(WaterInfo waterInfo) {
        this.setWaterLevel(waterInfo.getWaterLevel());
        this.setWaterSaturationLevel(waterInfo.getWaterSaturationLevel());
        this.setWaterExhaustionLevel(waterInfo.getWaterExhaustionLevel());
    }

    @Override
    public int getWaterLevel() {
        return this.waterLevel;
    }

    @Override
    public float getWaterExhaustionLevel() {
        return this.waterExhaustionLevel;
    }

    @Override
    public float getWaterSaturationLevel() {
        return this.waterSaturationLevel;
    }

    @Override
    public void checkWaterLevel(ServerPlayer player) {
        if (this.waterLevel <= 0) {
            player.hurt(new DamageSource(DamageHelper.getHolder(player.getServer(), HomeostaticDamageTypes.DEHYDRATION)), 1.0f);
        }
    }

    @Override
    public ListTag write() {
        ListTag listTag = new ListTag();
        CompoundTag tag = new CompoundTag();
        this.write(tag);
        listTag.add((Object)tag);
        return listTag;
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        tag.putInt("waterLevel", this.getWaterLevel());
        tag.putFloat("waterExhaustion", this.getWaterExhaustionLevel());
        tag.putFloat("waterSaturation", this.getWaterSaturationLevel());
        return tag;
    }

    @Override
    public void read(ListTag nbt) {
        this.read(nbt.getCompound(0));
    }

    @Override
    public void read(CompoundTag tag) {
        this.setWaterLevel(tag.getInt("waterLevel"));
        this.setWaterExhaustionLevel(tag.getFloat("waterExhaustion"));
        this.setWaterSaturationLevel(tag.getFloat("waterSaturation"));
    }
}

