/*
 * Decompiled with CFR 0.152.
 */
package homeostatic;

import homeostatic.Homeostatic;
import homeostatic.HomeostaticClientForge;
import homeostatic.common.CreativeTabs;
import homeostatic.common.HomeostaticModule;
import homeostatic.common.biome.BiomeCategory;
import homeostatic.common.biome.BiomeCategoryManager;
import homeostatic.common.biome.BiomeTypeData;
import homeostatic.common.biome.BiomeTypeDataManager;
import homeostatic.common.block.HomeostaticBlocks;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.fluid.ForgeFluidType;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.potions.HomeostaticPotions;
import homeostatic.common.recipe.HomeostaticRecipes;
import homeostatic.event.CapabilityEventHandler;
import homeostatic.event.ServerEventListener;
import homeostatic.network.NetworkHandler;
import homeostatic.util.RegistryHelper;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="homeostatic")
public class HomeostaticForge {
    public HomeostaticForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        this.registryInit();
        bus.register(RegistryListener.class);
        bus.register(CapabilityRegistry.class);
        bus.addListener(this::setup);
        Homeostatic.init();
        Homeostatic.initConfig();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::serverStart);
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ServerEventListener.class);
        MinecraftForge.EVENT_BUS.register(CapabilityEventHandler.class);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> HomeostaticClientForge::new);
        event.enqueueWork(() -> {
            BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43602_)}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42452_}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)HomeostaticPotions.FROST_RESISTANCE));
            BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)HomeostaticPotions.FROST_RESISTANCE)}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)HomeostaticPotions.LONG_FROST_RESISTANCE));
        });
    }

    private void registryInit() {
        HomeostaticForge.bind(ForgeRegistries.BLOCKS.getRegistryKey(), HomeostaticBlocks::init);
        HomeostaticForge.bind(ForgeRegistries.MOB_EFFECTS.getRegistryKey(), HomeostaticEffects::init);
        HomeostaticForge.bind(ForgeRegistries.FLUIDS.getRegistryKey(), HomeostaticFluids::init);
        HomeostaticForge.bind(ForgeRegistries.RECIPE_SERIALIZERS.getRegistryKey(), HomeostaticRecipes::init);
        HomeostaticForge.bind(ForgeRegistries.ITEMS.getRegistryKey(), HomeostaticItems::init);
        HomeostaticForge.bind(ForgeRegistries.POTIONS.getRegistryKey(), HomeostaticPotions::init);
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    public void serverStart(ServerStartedEvent event) {
        Registry biomeRegistry = RegistryHelper.getRegistry(event.getServer(), Registries.f_256952_);
        for (Map.Entry entry : biomeRegistry.m_6579_()) {
            ResourceKey biomeResourceKey = (ResourceKey)entry.getKey();
            ResourceLocation biomeName = biomeResourceKey.m_135782_();
            Holder.Reference biomeHolder = biomeRegistry.m_246971_(biomeResourceKey);
            BiomeCategory.Type biomeCategory = BiomeCategoryManager.getBiomeCategory((Holder<Biome>)biomeHolder);
            BiomeTypeData biomeData = BiomeTypeDataManager.getDataForBiome((Holder<Biome>)biomeHolder);
            Biome biome = (Biome)biomeHolder.m_203334_();
            Biome.Precipitation precipitation = this.getPrecipitation(biome);
            String temperatureModifier = biomeData.isFrozen() ? "FROZEN" : "NONE";
            float dayNightOffset = biomeData.getDayNightOffset(precipitation);
            double humidity = biomeData.getHumidity(precipitation);
            if (biomeName.toString().equals("terrablender:deferred_placeholder")) continue;
            if (biomeCategory == BiomeCategory.Type.MISSING) {
                Homeostatic.LOGGER.warn("Missing biome in registry, will set to neutral temperature for: {}", (Object)biomeName);
            }
            Homeostatic.LOGGER.debug("Biome: " + String.valueOf(biomeName) + "\nprecipitation_type=" + String.valueOf(precipitation) + "\ntemperature=" + biomeData.getTemperature(precipitation) + "\ntemperatureModifier=" + temperatureModifier + "\ndownfall=" + biome.getModifiedClimateSettings().f_47683_() + "\ndayNightOffset=" + dayNightOffset + "\nhumidity=" + humidity + "\nbiomeCategory=" + String.valueOf((Object)biomeCategory));
        }
    }

    private Biome.Precipitation getPrecipitation(Biome biome) {
        if (!biome.m_264473_()) {
            return Biome.Precipitation.NONE;
        }
        return biome.m_47554_() <= 0.15f ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }

    public static final class RegistryListener {
        private static boolean setupDone = false;

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerEvent(RegisterEvent event) {
            event.register(((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getRegistryKey(), ForgeFluidType::initTypes);
            CreativeTabs.init();
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void setupRegistries(FMLConstructModEvent event) {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            if (setupDone) {
                return;
            }
            setupDone = true;
            HomeostaticModule.initRegistries(bus);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerCreativeTab(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.f_256869_ || event.getTab() == CreativeTabs.ALL_ITEMS_TAB.get()) {
                for (Map.Entry<ResourceLocation, Item> entry : HomeostaticItems.getAll().entrySet()) {
                    Item item = entry.getValue();
                    event.m_246342_(new ItemStack((ItemLike)item));
                }
            }
        }

        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            NetworkHandler.init();
        }
    }
}

