/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.biome;

import homeostatic.common.biome.BiomeCategoryManager;
import homeostatic.common.biome.BiomeTypeData;
import homeostatic.common.biome.BiomeTypeDataManager;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;

public record ClimateSettings(Holder<Biome> biome, boolean precipitation, float temperature, Biome.TemperatureModifier modifier, float downfall) {
    private static BiomeTypeData biomeTypeData;

    public ClimateSettings {
        biomeTypeData = BiomeTypeDataManager.getDataForBiome(biome);
    }

    @Override
    public String toString() {
        return "Biome: " + this.biome.toString() + "\nprecipitation_type=" + String.valueOf(this.getPrecipitationType()) + "\ntemperature=" + this.temperature + "\ntemperatureModifier=" + String.valueOf(this.modifier) + "\ndownfall=" + this.downfall + "\ndayNightOffset=" + biomeTypeData.getDayNightOffset(this.getPrecipitationType()) + "\nhumidity=" + biomeTypeData.getHumidity(this.getPrecipitationType()) + "\nbiomeCategory=" + String.valueOf((Object)BiomeCategoryManager.getBiomeCategory(this.biome));
    }

    public Biome.Precipitation getPrecipitationType() {
        if (!this.precipitation) {
            return Biome.Precipitation.NONE;
        }
        return this.temperature <= 0.15f ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }

    public static BiomeTypeData getBiomeData() {
        return biomeTypeData;
    }
}

