/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.block;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.block.BlockRadiation;
import homeostatic.platform.Services;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BlockRadiationManager
extends SimpleJsonResourceReloadListener {
    private static final Map<Block, BlockRadiation> RADIATION_BLOCKS = new HashMap<Block, BlockRadiation>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockRadiation.class, (Object)new BlockRadiation.Serializer()).create();

    public BlockRadiationManager() {
        super(GSON, "environment/block_radiation");
    }

    public static JsonElement parseBlockRadiation(BlockRadiation blockRadiation) {
        return GSON.toJsonTree((Object)blockRadiation);
    }

    public static BlockRadiation getBlockRadiation(Block block) {
        return RADIATION_BLOCKS.get(block);
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        RADIATION_BLOCKS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            try {
                BlockRadiation blockRadiation = (BlockRadiation)GSON.fromJson(entry.getValue(), BlockRadiation.class);
                Block block = Services.PLATFORM.getBlock(blockRadiation.loc());
                if (block == Blocks.f_50016_ || block == null) continue;
                RADIATION_BLOCKS.put(block, blockRadiation);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse block radiation {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} radiation blocks", (Object)RADIATION_BLOCKS.size());
    }
}

