/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.capabilities;

import homeostatic.common.capabilities.ITemperature;
import homeostatic.common.damagesource.HomeostaticDamageTypes;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.TemperatureThreshold;
import homeostatic.util.DamageHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;

public class Temperature
implements ITemperature {
    private float skinTemperature;
    private float lastSkinTemperature;
    private float coreTemperature;
    private float localTemperature;

    public Temperature() {
        this.skinTemperature = TemperatureThreshold.NORMAL.temperature;
        this.lastSkinTemperature = TemperatureThreshold.NORMAL.temperature;
        this.coreTemperature = TemperatureThreshold.NORMAL.temperature;
        this.localTemperature = 0.0f;
    }

    @Override
    public void setSkinTemperature(float skinTemperature) {
        this.skinTemperature = skinTemperature;
    }

    @Override
    public void setLastSkinTemperature(float lastSkinTemperature) {
        this.lastSkinTemperature = lastSkinTemperature;
    }

    @Override
    public void setCoreTemperature(float coreTemperature) {
        this.coreTemperature = coreTemperature;
    }

    @Override
    public void setLocalTemperature(float temperature) {
        this.localTemperature = temperature;
    }

    @Override
    public void setTemperatureData(float localTemperature, BodyTemperature bodyTemperature) {
        this.setSkinTemperature(bodyTemperature.getSkinTemperature());
        this.setLastSkinTemperature(bodyTemperature.getLastSkinTemperature());
        this.setCoreTemperature(bodyTemperature.getCoreTemperature());
        this.setLocalTemperature(localTemperature);
    }

    @Override
    public float getSkinTemperature() {
        return this.skinTemperature;
    }

    @Override
    public float getLastSkinTemperature() {
        return this.lastSkinTemperature;
    }

    @Override
    public float getCoreTemperature() {
        return this.coreTemperature;
    }

    @Override
    public float getLocalTemperature() {
        return this.localTemperature;
    }

    @Override
    public void checkTemperatureLevel(Player player) {
        float amount;
        if (this.coreTemperature < TemperatureThreshold.LOW.temperature && !player.m_21023_(HomeostaticEffects.FROST_RESISTANCE)) {
            player.m_146917_(player.m_146888_() + 5);
        } else if (this.coreTemperature > TemperatureThreshold.HIGH.temperature) {
            amount = (1.0f + (this.coreTemperature - TemperatureThreshold.HIGH.temperature)) * 0.5f;
            player.m_6469_(new DamageSource(DamageHelper.getHolder(player.m_20194_(), HomeostaticDamageTypes.HYPERTHERMIA)), amount);
        }
        if (this.skinTemperature > TemperatureThreshold.SCALDING.temperature) {
            amount = (1.0f + (this.skinTemperature - TemperatureThreshold.SCALDING.temperature)) * 0.25f;
            player.m_6469_(new DamageSource(DamageHelper.getHolder(player.m_20194_(), HomeostaticDamageTypes.SCALDING)), amount);
        }
    }

    @Override
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("skinTemperature", this.getSkinTemperature());
        tag.m_128350_("lastSkinTemperature", this.getLastSkinTemperature());
        tag.m_128350_("coreTemperature", this.getCoreTemperature());
        tag.m_128350_("localTemperature", this.getLocalTemperature());
        return tag;
    }

    @Override
    public void read(CompoundTag tag) {
        this.setSkinTemperature(tag.m_128457_("skinTemperature"));
        this.setLastSkinTemperature(tag.m_128457_("lastSkinTemperature"));
        this.setCoreTemperature(tag.m_128457_("coreTemperature"));
        this.setLocalTemperature(tag.m_128457_("localTemperature"));
    }
}

