/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.fluid;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import homeostatic.common.Hydration;
import java.lang.reflect.Type;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import technology.roughness.whitenoise.util.ResourceLocationHelper;

public record DrinkingFluid(ResourceLocation loc, int amount, float saturation, int potency, int duration, float chance) {
    public static Hydration getHydration(DrinkingFluid fluid) {
        return new Hydration(fluid.amount(), fluid.saturation(), fluid.potency(), fluid.duration(), fluid.chance());
    }

    public static CompoundTag serialize(DrinkingFluid drinkingFluid) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("loc", drinkingFluid.loc().toString());
        tag.m_128405_("amount", drinkingFluid.amount());
        tag.m_128350_("saturation", drinkingFluid.saturation());
        tag.m_128405_("potency", drinkingFluid.potency());
        tag.m_128405_("duration", drinkingFluid.duration());
        tag.m_128350_("chance", drinkingFluid.chance());
        return tag;
    }

    public static DrinkingFluid deserialize(CompoundTag tag) {
        return new DrinkingFluid(ResourceLocationHelper.mcLoc((String)tag.m_128461_("loc")), tag.m_128451_("amount"), tag.m_128457_("saturation"), tag.m_128451_("potency"), tag.m_128451_("duration"), tag.m_128457_("chance"));
    }

    public static class Serializer
    implements JsonDeserializer<DrinkingFluid>,
    JsonSerializer<DrinkingFluid> {
        public DrinkingFluid deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"data");
            return new DrinkingFluid(ResourceLocationHelper.mcLoc((String)json.get("fluid").getAsString()), json.get("amount").getAsInt(), json.get("saturation").getAsFloat(), json.get("effect_potency").getAsInt(), json.get("effect_duration").getAsInt(), json.get("effect_chance").getAsFloat());
        }

        public JsonElement serialize(DrinkingFluid drinkingFluid, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("fluid", drinkingFluid.loc().toString());
            json.addProperty("amount", (Number)drinkingFluid.amount());
            json.addProperty("saturation", (Number)Float.valueOf(drinkingFluid.saturation()));
            json.addProperty("effect_potency", (Number)drinkingFluid.potency());
            json.addProperty("effect_duration", (Number)drinkingFluid.duration());
            json.addProperty("effect_chance", (Number)Float.valueOf(drinkingFluid.chance()));
            return json;
        }
    }
}

