/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.fluid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.fluid.DrinkingFluid;
import homeostatic.platform.Services;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class DrinkingFluidManager
extends SimpleJsonResourceReloadListener {
    private static final Map<Fluid, DrinkingFluid> FLUIDS = new HashMap<Fluid, DrinkingFluid>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DrinkingFluid.class, (Object)new DrinkingFluid.Serializer()).create();

    public DrinkingFluidManager() {
        super(GSON, "environment/fluids");
    }

    public static JsonElement parseDrinkingFluid(DrinkingFluid drinkingFluid) {
        return GSON.toJsonTree((Object)drinkingFluid);
    }

    public static DrinkingFluid get(Fluid fluid) {
        return FLUIDS.get(fluid);
    }

    public static void write(FriendlyByteBuf buf) {
        buf.writeInt(FLUIDS.size());
        for (Map.Entry<Fluid, DrinkingFluid> entry : FLUIDS.entrySet()) {
            CompoundTag drinkingFluidTag = DrinkingFluid.serialize(entry.getValue());
            buf.m_130085_(Services.PLATFORM.getFluidResourceLocation(entry.getKey()));
            buf.m_130079_(drinkingFluidTag);
        }
    }

    public static ListTag write() {
        ListTag tag = new ListTag();
        for (Map.Entry<Fluid, DrinkingFluid> entry : FLUIDS.entrySet()) {
            CompoundTag drinkingFluidTag = DrinkingFluid.serialize(entry.getValue());
            tag.add((Object)drinkingFluidTag);
        }
        return tag;
    }

    public static void read(FriendlyByteBuf buf) {
        FLUIDS.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation fluidLoc = buf.m_130281_();
            CompoundTag drinkingFluidTag = buf.m_130260_();
            Fluid fluid = Services.PLATFORM.getFluid(fluidLoc);
            if (fluid == Fluids.f_76191_ || fluid == null || drinkingFluidTag == null) continue;
            DrinkingFluid drinkingFluid = DrinkingFluid.deserialize(drinkingFluidTag);
            FLUIDS.put(fluid, drinkingFluid);
        }
        Homeostatic.LOGGER.info("Synchronized {} drinking fluids", (Object)FLUIDS.size());
    }

    public static void read(ListTag tag) {
        FLUIDS.clear();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag drinkingFluidTag = tag.m_128728_(i);
            DrinkingFluid drinkingFluid = DrinkingFluid.deserialize(drinkingFluidTag);
            Fluid fluid = Services.PLATFORM.getFluid(drinkingFluid.loc());
            if (fluid == Fluids.f_76191_ || fluid == null) continue;
            FLUIDS.put(fluid, drinkingFluid);
        }
        Homeostatic.LOGGER.info("Loaded {} drinking fluids from NBT", (Object)FLUIDS.size());
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        FLUIDS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            try {
                DrinkingFluid drinkingFluid = (DrinkingFluid)GSON.fromJson(entry.getValue(), DrinkingFluid.class);
                Fluid fluid = Services.PLATFORM.getFluid(drinkingFluid.loc());
                if (fluid == Fluids.f_76191_ || fluid == null) continue;
                FLUIDS.put(fluid, drinkingFluid);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse drinking fluid {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} drinking fluids", (Object)FLUIDS.size());
    }
}

