/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.recipe;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import homeostatic.common.recipe.HomeostaticRecipes;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RemoveArmorEnhancement
extends CustomRecipe {
    public RemoveArmorEnhancement(ResourceLocation pId, CraftingBookCategory category) {
        super(pId, category);
    }

    public boolean matches(CraftingContainer pContainer, Level pLevel) {
        Pair<ItemStack, ItemStack> check = this.checkContainer(pContainer);
        ItemStack armor = (ItemStack)check.getFirst();
        ItemStack removalItem = (ItemStack)check.getSecond();
        return removalItem != null && armor != null;
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess registryAccess) {
        Pair<ItemStack, ItemStack> check = this.checkContainer(pContainer);
        ItemStack armorCopy = ((ItemStack)check.getFirst()).m_41777_();
        ItemStack removalItem = (ItemStack)check.getSecond();
        CompoundTag tags = armorCopy.m_41784_();
        if (removalItem.m_150930_(Items.f_42574_)) {
            if (tags.m_128441_("insulation")) {
                tags.m_128473_("insulation");
            }
        } else if (removalItem.m_150930_(Items.f_42448_)) {
            if (tags.m_128441_("waterproof")) {
                tags.m_128473_("waterproof");
            }
        } else if (removalItem.m_150930_(Items.f_42447_) && tags.m_128441_("radiation_protection")) {
            tags.m_128473_("radiation_protection");
        }
        return armorCopy;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return HomeostaticRecipes.REMOVE_ARMOR_ENHANCEMENT_SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pContainer) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = pContainer.m_8020_(i);
            if (item.m_150930_(Items.f_42574_)) {
                ItemStack shears = item.m_41777_();
                shears.m_220157_(1, RandomSource.m_216327_(), null);
                nonnulllist.set(i, (Object)shears);
                continue;
            }
            if (!item.m_150930_(Items.f_42447_) && !item.m_150930_(Items.f_42448_)) continue;
            ItemStack bucket = new ItemStack((ItemLike)Items.f_42446_);
            nonnulllist.set(i, (Object)bucket);
        }
        return nonnulllist;
    }

    public Pair<ItemStack, ItemStack> checkContainer(CraftingContainer pContainer) {
        ArrayList ingredients = Lists.newArrayList();
        ItemStack removalItem = null;
        ItemStack armor = null;
        boolean hasInsulation = false;
        boolean hasWaterproof = false;
        boolean hasRadiation = false;
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            ItemStack ingredient = pContainer.m_8020_(i);
            if (ingredient.m_150930_(Items.f_42574_) && !hasWaterproof && !hasRadiation) {
                hasInsulation = true;
                removalItem = ingredient;
                ingredients.add(ingredient);
                continue;
            }
            if (ingredient.m_150930_(Items.f_42448_) && !hasInsulation && !hasRadiation) {
                hasWaterproof = true;
                removalItem = ingredient;
                ingredients.add(ingredient);
                continue;
            }
            if (ingredient.m_150930_(Items.f_42447_) && !hasWaterproof && !hasInsulation) {
                hasRadiation = true;
                removalItem = ingredient;
                ingredients.add(ingredient);
                continue;
            }
            if (!(ingredient.m_41720_() instanceof ArmorItem)) continue;
            armor = ingredient;
        }
        if (ingredients.size() != 1) {
            removalItem = null;
        }
        return Pair.of(armor, removalItem);
    }
}

