/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import com.google.gson.JsonElement;
import homeostatic.common.biome.BiomeCategory;
import homeostatic.common.biome.BiomeCategoryManager;
import homeostatic.data.integration.ModIntegration;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.jetbrains.annotations.NotNull;

public class BiomeCategoryProvider
implements DataProvider {
    private final Map<ResourceLocation, BiomeCategory> BIOME_CATEGORY_MAP = new HashMap<ResourceLocation, BiomeCategory>();
    private final PackOutput packOutput;

    public BiomeCategoryProvider(@NotNull PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    protected void registerBiomeCategories() {
        this.add((ResourceKey<Biome>)Biomes.f_48173_, BiomeCategory.Type.NONE);
        this.add((ResourceKey<Biome>)Biomes.f_48202_, BiomeCategory.Type.PLAINS);
        this.add((ResourceKey<Biome>)Biomes.f_48176_, BiomeCategory.Type.PLAINS);
        this.add((ResourceKey<Biome>)Biomes.f_186761_, BiomeCategory.Type.ICY);
        this.add((ResourceKey<Biome>)Biomes.f_48182_, BiomeCategory.Type.ICY);
        this.add((ResourceKey<Biome>)Biomes.f_48203_, BiomeCategory.Type.DESERT);
        this.add((ResourceKey<Biome>)Biomes.f_48207_, BiomeCategory.Type.SWAMP);
        this.add((ResourceKey<Biome>)Biomes.f_220595_, BiomeCategory.Type.SWAMP);
        this.add((ResourceKey<Biome>)Biomes.f_186755_, BiomeCategory.Type.FOREST);
        this.add((ResourceKey<Biome>)Biomes.f_48149_, BiomeCategory.Type.FOREST);
        this.add((ResourceKey<Biome>)Biomes.f_186762_, BiomeCategory.Type.FOREST);
        this.add((ResourceKey<Biome>)Biomes.f_48151_, BiomeCategory.Type.FOREST);
        this.add((ResourceKey<Biome>)Biomes.f_48205_, BiomeCategory.Type.FOREST);
        this.add((ResourceKey<Biome>)Biomes.f_48179_, BiomeCategory.Type.FOREST);
        this.add((ResourceKey<Biome>)Biomes.f_186763_, BiomeCategory.Type.TAIGA);
        this.add((ResourceKey<Biome>)Biomes.f_48206_, BiomeCategory.Type.TAIGA);
        this.add((ResourceKey<Biome>)Biomes.f_48152_, BiomeCategory.Type.TAIGA);
        this.add((ResourceKey<Biome>)Biomes.f_186764_, BiomeCategory.Type.TAIGA);
        this.add((ResourceKey<Biome>)Biomes.f_48157_, BiomeCategory.Type.SAVANNA);
        this.add((ResourceKey<Biome>)Biomes.f_48158_, BiomeCategory.Type.SAVANNA);
        this.add((ResourceKey<Biome>)Biomes.f_186768_, BiomeCategory.Type.SAVANNA);
        this.add((ResourceKey<Biome>)Biomes.f_186765_, BiomeCategory.Type.EXTREME_HILLS);
        this.add((ResourceKey<Biome>)Biomes.f_186766_, BiomeCategory.Type.EXTREME_HILLS);
        this.add((ResourceKey<Biome>)Biomes.f_186767_, BiomeCategory.Type.EXTREME_HILLS);
        this.add((ResourceKey<Biome>)Biomes.f_186760_, BiomeCategory.Type.BEACH);
        this.add((ResourceKey<Biome>)Biomes.f_48222_, BiomeCategory.Type.JUNGLE);
        this.add((ResourceKey<Biome>)Biomes.f_186769_, BiomeCategory.Type.JUNGLE);
        this.add((ResourceKey<Biome>)Biomes.f_48197_, BiomeCategory.Type.JUNGLE);
        this.add((ResourceKey<Biome>)Biomes.f_48159_, BiomeCategory.Type.MESA);
        this.add((ResourceKey<Biome>)Biomes.f_48194_, BiomeCategory.Type.MESA);
        this.add((ResourceKey<Biome>)Biomes.f_186753_, BiomeCategory.Type.MESA);
        this.add((ResourceKey<Biome>)Biomes.f_186756_, BiomeCategory.Type.MOUNTAIN);
        this.add((ResourceKey<Biome>)Biomes.f_186758_, BiomeCategory.Type.MOUNTAIN);
        this.add((ResourceKey<Biome>)Biomes.f_186757_, BiomeCategory.Type.MOUNTAIN);
        this.add((ResourceKey<Biome>)Biomes.f_186754_, BiomeCategory.Type.MOUNTAIN);
        this.add((ResourceKey<Biome>)Biomes.f_271432_, BiomeCategory.Type.FOREST);
        this.add((ResourceKey<Biome>)Biomes.f_186759_, BiomeCategory.Type.MOUNTAIN);
        this.add((ResourceKey<Biome>)Biomes.f_48208_, BiomeCategory.Type.RIVER);
        this.add((ResourceKey<Biome>)Biomes.f_48212_, BiomeCategory.Type.RIVER);
        this.add((ResourceKey<Biome>)Biomes.f_48217_, BiomeCategory.Type.BEACH);
        this.add((ResourceKey<Biome>)Biomes.f_48148_, BiomeCategory.Type.BEACH);
        this.add((ResourceKey<Biome>)Biomes.f_48166_, BiomeCategory.Type.WARM_OCEAN);
        this.add((ResourceKey<Biome>)Biomes.f_48167_, BiomeCategory.Type.LUKEWARM_OCEAN);
        this.add((ResourceKey<Biome>)Biomes.f_48170_, BiomeCategory.Type.DEEP_LUKEWARM_OCEAN);
        this.add((ResourceKey<Biome>)Biomes.f_48172_, BiomeCategory.Type.OCEAN);
        this.add((ResourceKey<Biome>)Biomes.f_48211_, BiomeCategory.Type.COLD_OCEAN);
        this.add((ResourceKey<Biome>)Biomes.f_48174_, BiomeCategory.Type.OCEAN);
        this.add((ResourceKey<Biome>)Biomes.f_48225_, BiomeCategory.Type.OCEAN);
        this.add((ResourceKey<Biome>)Biomes.f_48168_, BiomeCategory.Type.COLD_OCEAN);
        this.add((ResourceKey<Biome>)Biomes.f_48171_, BiomeCategory.Type.DEEP_COLD_OCEAN);
        this.add((ResourceKey<Biome>)Biomes.f_48215_, BiomeCategory.Type.MUSHROOM);
        this.add((ResourceKey<Biome>)Biomes.f_151784_, BiomeCategory.Type.UNDERGROUND);
        this.add((ResourceKey<Biome>)Biomes.f_220594_, BiomeCategory.Type.UNDERGROUND);
        this.add((ResourceKey<Biome>)Biomes.f_151785_, BiomeCategory.Type.UNDERGROUND);
        this.add((ResourceKey<Biome>)Biomes.f_48209_, BiomeCategory.Type.NETHER);
        this.add((ResourceKey<Biome>)Biomes.f_48201_, BiomeCategory.Type.NETHER);
        this.add((ResourceKey<Biome>)Biomes.f_48200_, BiomeCategory.Type.NETHER);
        this.add((ResourceKey<Biome>)Biomes.f_48199_, BiomeCategory.Type.NETHER);
        this.add((ResourceKey<Biome>)Biomes.f_48175_, BiomeCategory.Type.NETHER);
        this.add((ResourceKey<Biome>)Biomes.f_48210_, BiomeCategory.Type.THEEND);
        this.add((ResourceKey<Biome>)Biomes.f_48164_, BiomeCategory.Type.THEEND);
        this.add((ResourceKey<Biome>)Biomes.f_48163_, BiomeCategory.Type.THEEND);
        this.add((ResourceKey<Biome>)Biomes.f_48162_, BiomeCategory.Type.THEEND);
        this.add((ResourceKey<Biome>)Biomes.f_48165_, BiomeCategory.Type.THEEND);
        this.add(ModIntegration.bopLoc("seasonal_forest"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.bopLoc("seasonal_orchard"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.bopLoc("pumpkin_patch"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.bopLoc("boreal_forest"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.bopLoc("marsh"), BiomeCategory.Type.SWAMP);
        this.add(ModIntegration.bopLoc("bayou"), BiomeCategory.Type.SWAMP);
        this.add(ModIntegration.bopLoc("fungal_jungle"), BiomeCategory.Type.SWAMP);
        this.add(ModIntegration.bopLoc("rainbow_hills"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.bopLoc("snowy_coniferous_forest"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.bopLoc("snowy_fir_clearing"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.bopLoc("snowy_maple_woods"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.bopLoc("floodplain"), BiomeCategory.Type.RAINFOREST);
        this.add(ModIntegration.bopLoc("rocky_rainforest"), BiomeCategory.Type.RAINFOREST);
        this.add(ModIntegration.bopLoc("rainforest"), BiomeCategory.Type.RAINFOREST);
        this.add(ModIntegration.bopLoc("wetland"), BiomeCategory.Type.SWAMP);
        this.add(ModIntegration.bopLoc("grassland"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("clover_patch"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("muskeg"), BiomeCategory.Type.ICY);
        this.add(ModIntegration.bopLoc("shrubland"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("rocky_shrubland"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("cherry_blossom_grove"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("bamboo_grove"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("field"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("forested_field"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("lavender_field"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("lavender_forest"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("orchard"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("pasture"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("prairie"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("fir_clearing"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("coniferous_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("ominous_woods"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("origin_valley"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("moor"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("highland"), BiomeCategory.Type.EXTREME_HILLS);
        this.add(ModIntegration.bopLoc("crag"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.bopLoc("jade_cliffs"), BiomeCategory.Type.EXTREME_HILLS);
        this.add(ModIntegration.bopLoc("maple_woods"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("mystic_grove"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("old_growth_woodland"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("redwood_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("woodland"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("auroral_garden"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("snowblossom_grove"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("dryland"), BiomeCategory.Type.DRYLAND);
        this.add(ModIntegration.bopLoc("cold_desert"), BiomeCategory.Type.COLD_DESERT);
        this.add(ModIntegration.bopLoc("dune_beach"), BiomeCategory.Type.BEACH);
        this.add(ModIntegration.bopLoc("scrubland"), BiomeCategory.Type.SAVANNA);
        this.add(ModIntegration.bopLoc("wooded_scrubland"), BiomeCategory.Type.SAVANNA);
        this.add(ModIntegration.bopLoc("wasteland"), BiomeCategory.Type.DESERT);
        this.add(ModIntegration.bopLoc("bog"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.bopLoc("tundra"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.bopLoc("crystalline_chasm"), BiomeCategory.Type.NETHER);
        this.add(ModIntegration.bopLoc("erupting_inferno"), BiomeCategory.Type.NETHER);
        this.add(ModIntegration.bopLoc("undergrowth"), BiomeCategory.Type.NETHER);
        this.add(ModIntegration.bopLoc("visceral_heap"), BiomeCategory.Type.NETHER);
        this.add(ModIntegration.bopLoc("withered_abyss"), BiomeCategory.Type.NETHER);
        this.add(ModIntegration.bopLoc("dead_forest"), BiomeCategory.Type.EXTREME_HILLS);
        this.add(ModIntegration.bopLoc("glowing_grotto"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.bopLoc("spider_nest"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.bopLoc("volcano"), BiomeCategory.Type.VOLCANIC);
        this.add(ModIntegration.bopLoc("volcanic_plains"), BiomeCategory.Type.VOLCANIC);
        this.add(ModIntegration.bopLoc("old_growth_dead_forest"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.bopLoc("tropics"), BiomeCategory.Type.JUNGLE);
        this.add(ModIntegration.bopLoc("lush_desert"), BiomeCategory.Type.LUSH_DESERT);
        this.add(ModIntegration.bopLoc("lush_savanna"), BiomeCategory.Type.LUSH_DESERT);
        this.add(ModIntegration.bopLoc("mediterranean_forest"), BiomeCategory.Type.LUSH_DESERT);
        this.add(ModIntegration.bopLoc("wasteland_steppe"), BiomeCategory.Type.MESA);
        this.add(ModIntegration.bopLoc("overgrown_greens"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bopLoc("jacaranda_glade"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("wintry_origin_valley"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.bopLoc("gravel_beach"), BiomeCategory.Type.BEACH);
        this.add(ModIntegration.bopLoc("hot_springs"), BiomeCategory.Type.JUNGLE);
        this.add(ModIntegration.bopLoc("aspen_glade"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bopLoc("end_wilds"), BiomeCategory.Type.THEEND);
        this.add(ModIntegration.bopLoc("end_corruption"), BiomeCategory.Type.THEEND);
        this.add(ModIntegration.bopLoc("end_reef"), BiomeCategory.Type.THEEND);
        this.add(ModIntegration.bygLoc("allium_shrubland"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bygLoc("amaranth_grassland"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bygLoc("araucaria_savanna"), BiomeCategory.Type.SAVANNA);
        this.add(ModIntegration.bygLoc("aspen_boreal"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bygLoc("atacama_outback"), BiomeCategory.Type.LUSH_DESERT);
        this.add(ModIntegration.bygLoc("baobab_savanna"), BiomeCategory.Type.SAVANNA);
        this.add(ModIntegration.bygLoc("basalt_barrera"), BiomeCategory.Type.BEACH);
        this.add(ModIntegration.bygLoc("bayou"), BiomeCategory.Type.SWAMP);
        this.add(ModIntegration.bygLoc("black_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bygLoc("canadian_shield"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.bygLoc("cika_woods"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bygLoc("coconino_meadow"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bygLoc("coniferous_forest"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.bygLoc("crag_gardens"), BiomeCategory.Type.JUNGLE);
        this.add(ModIntegration.bygLoc("crimson_tundra"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bygLoc("cypress_swamplands"), BiomeCategory.Type.SWAMP);
        this.add(ModIntegration.bygLoc("dacite_ridges"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.bygLoc("dacite_shore"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.bygLoc("dead_sea"), BiomeCategory.Type.DEAD_SEA);
        this.add(ModIntegration.bygLoc("ebony_woods"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bygLoc("enchanted_tangle"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bygLoc("eroded_borealis"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.bygLoc("firecracker_chaparral"), BiomeCategory.Type.SAVANNA);
        this.add(ModIntegration.bygLoc("forgotten_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bygLoc("fragment_jungle"), BiomeCategory.Type.JUNGLE);
        this.add(ModIntegration.bygLoc("frosted_coniferous_forest"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.bygLoc("frosted_taiga"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.bygLoc("howling_peaks"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.bygLoc("ironwood_gour"), BiomeCategory.Type.SAVANNA);
        this.add(ModIntegration.bygLoc("jacaranda_jungle"), BiomeCategory.Type.RAINFOREST);
        this.add(ModIntegration.bygLoc("lush_stacks"), BiomeCategory.Type.WARM_OCEAN);
        this.add(ModIntegration.bygLoc("maple_taiga"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.bygLoc("mojave_desert"), BiomeCategory.Type.DESERT);
        this.add(ModIntegration.bygLoc("orchard"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bygLoc("overgrowth_woodlands"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bygLoc("pale_bog"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.bygLoc("prairie"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bygLoc("pumpkin_valley"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bygLoc("rainbow_beach"), BiomeCategory.Type.BEACH);
        this.add(ModIntegration.bygLoc("red_rock_valley"), BiomeCategory.Type.MESA);
        this.add(ModIntegration.bygLoc("redwood_thicket"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bygLoc("rose_fields"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.bygLoc("rugged_badlands"), BiomeCategory.Type.MESA);
        this.add(ModIntegration.bygLoc("sakura_grove"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bygLoc("sierra_badlands"), BiomeCategory.Type.MESA);
        this.add(ModIntegration.bygLoc("shattered_glacier"), BiomeCategory.Type.ICY);
        this.add(ModIntegration.bygLoc("skyrise_vale"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bygLoc("temperate_grove"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.bygLoc("tropical_rainforest"), BiomeCategory.Type.RAINFOREST);
        this.add(ModIntegration.bygLoc("weeping_witch_forest"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.bygLoc("white_mangrove_marshes"), BiomeCategory.Type.SWAMP);
        this.add(ModIntegration.bygLoc("windswept_desert"), BiomeCategory.Type.DESERT);
        this.add(ModIntegration.bygLoc("zelkova_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.tfLoc("forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.tfLoc("dense_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.tfLoc("firefly_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.tfLoc("clearing"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.tfLoc("oak_savannah"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.tfLoc("stream"), BiomeCategory.Type.RIVER);
        this.add(ModIntegration.tfLoc("lake"), BiomeCategory.Type.RIVER);
        this.add(ModIntegration.tfLoc("mushroom_forest"), BiomeCategory.Type.MUSHROOM);
        this.add(ModIntegration.tfLoc("dense_mushroom_forest"), BiomeCategory.Type.MUSHROOM);
        this.add(ModIntegration.tfLoc("enchanted_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.tfLoc("spooky_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.tfLoc("swamp"), BiomeCategory.Type.SWAMP);
        this.add(ModIntegration.tfLoc("fire_swamp"), BiomeCategory.Type.SWAMP);
        this.add(ModIntegration.tfLoc("dark_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.tfLoc("dark_forest_center"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.tfLoc("snowy_forest"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.tfLoc("glacier"), BiomeCategory.Type.ICY);
        this.add(ModIntegration.tfLoc("highlands"), BiomeCategory.Type.DRYLAND);
        this.add(ModIntegration.tfLoc("thornlands"), BiomeCategory.Type.DRYLAND);
        this.add(ModIntegration.tfLoc("final_plateau"), BiomeCategory.Type.DRYLAND);
        this.add(ModIntegration.tfLoc("underground"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.arsLoc("archwood_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.arseLoc("blazing_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.arseLoc("cascading_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.arseLoc("flourishing_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.arseLoc("flashing_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.ugLoc("ancient_sea"), BiomeCategory.Type.WARM_OCEAN);
        this.add(ModIntegration.ugLoc("barren_abyss"), BiomeCategory.Type.DRYLAND);
        this.add(ModIntegration.ugLoc("blood_mushroom_bog"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.ugLoc("dead_sea"), BiomeCategory.Type.DEAD_SEA);
        this.add(ModIntegration.ugLoc("dense_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.ugLoc("forgotten_field"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.ugLoc("frostfields"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.ugLoc("frosty_smogstem_forest"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.ugLoc("gronglegrowth"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.ugLoc("icy_sea"), BiomeCategory.Type.COLD_OCEAN);
        this.add(ModIntegration.ugLoc("indigo_mushroom_bog"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.ugLoc("ink_mushroom_bog"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.ugLoc("smog_spires"), BiomeCategory.Type.DRYLAND);
        this.add(ModIntegration.ugLoc("smogstem_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.ugLoc("veil_mushroom_bog"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.ugLoc("wigglewood_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("alpha_islands"), BiomeCategory.Type.BEACH);
        this.add(ModIntegration.terralithLoc("alpha_islands_winter"), BiomeCategory.Type.BEACH);
        this.add(ModIntegration.terralithLoc("alpine_grove"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("alpine_highlands"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("amethyst_canyon"), BiomeCategory.Type.JUNGLE);
        this.add(ModIntegration.terralithLoc("amethyst_rainforest"), BiomeCategory.Type.RAINFOREST);
        this.add(ModIntegration.terralithLoc("ancient_sands"), BiomeCategory.Type.DESERT);
        this.add(ModIntegration.terralithLoc("arid_highlands"), BiomeCategory.Type.DRYLAND);
        this.add(ModIntegration.terralithLoc("ashen_savanna"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("basalt_cliffs"), BiomeCategory.Type.DRYLAND);
        this.add(ModIntegration.terralithLoc("birch_taiga"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("blooming_plateau"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.terralithLoc("blooming_valley"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("brushland"), BiomeCategory.Type.SAVANNA);
        this.add(ModIntegration.terralithLoc("bryce_canyon"), BiomeCategory.Type.MESA);
        this.add(ModIntegration.terralithLoc("caldera"), BiomeCategory.Type.VOLCANIC);
        this.add(ModIntegration.terralithLoc("cave/andesite_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/crystal_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/deep_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/desert_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/diorite_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/frostfire_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/fungal_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/granite_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/ice_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/infested_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/mantle_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/thermal_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/tuff_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cave/underground_jungle"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.terralithLoc("cloud_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("cold_shrubland"), BiomeCategory.Type.SAVANNA);
        this.add(ModIntegration.terralithLoc("desert_canyon"), BiomeCategory.Type.DESERT);
        this.add(ModIntegration.terralithLoc("desert_oasis"), BiomeCategory.Type.DESERT);
        this.add(ModIntegration.terralithLoc("desert_spires"), BiomeCategory.Type.MESA);
        this.add(ModIntegration.terralithLoc("emerald_peaks"), BiomeCategory.Type.EXTREME_HILLS);
        this.add(ModIntegration.terralithLoc("forested_highlands"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("fractured_savanna"), BiomeCategory.Type.SAVANNA);
        this.add(ModIntegration.terralithLoc("frozen_cliffs"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.terralithLoc("glacial_chasm"), BiomeCategory.Type.ICY);
        this.add(ModIntegration.terralithLoc("granite_cliffs"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.terralithLoc("gravel_beach"), BiomeCategory.Type.BEACH);
        this.add(ModIntegration.terralithLoc("gravel_desert"), BiomeCategory.Type.DESERT);
        this.add(ModIntegration.terralithLoc("haze_mountain"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("highlands"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("hot_shrubland"), BiomeCategory.Type.DRYLAND);
        this.add(ModIntegration.terralithLoc("ice_marsh"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.terralithLoc("jungle_mountains"), BiomeCategory.Type.JUNGLE);
        this.add(ModIntegration.terralithLoc("lavender_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("lavender_valley"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("lush_desert"), BiomeCategory.Type.LUSH_DESERT);
        this.add(ModIntegration.terralithLoc("lush_valley"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.terralithLoc("mirage_isles"), BiomeCategory.Type.BEACH);
        this.add(ModIntegration.terralithLoc("moonlight_grove"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("moonlight_valley"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("mountain_steppe"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("orchid_swamp"), BiomeCategory.Type.SWAMP);
        this.add(ModIntegration.terralithLoc("painted_mountains"), BiomeCategory.Type.EXTREME_HILLS);
        this.add(ModIntegration.terralithLoc("red_oasis"), BiomeCategory.Type.DESERT);
        this.add(ModIntegration.terralithLoc("rocky_jungle"), BiomeCategory.Type.JUNGLE);
        this.add(ModIntegration.terralithLoc("rocky_mountains"), BiomeCategory.Type.EXTREME_HILLS);
        this.add(ModIntegration.terralithLoc("rocky_shrubland"), BiomeCategory.Type.LUSH_DESERT);
        this.add(ModIntegration.terralithLoc("sakura_grove"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("sakura_valley"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("sandstone_valley"), BiomeCategory.Type.DESERT);
        this.add(ModIntegration.terralithLoc("savanna_badlands"), BiomeCategory.Type.MESA);
        this.add(ModIntegration.terralithLoc("savanna_slopes"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("scarlet_mountains"), BiomeCategory.Type.EXTREME_HILLS);
        this.add(ModIntegration.terralithLoc("shield"), BiomeCategory.Type.EXTREME_HILLS);
        this.add(ModIntegration.terralithLoc("shield_clearing"), BiomeCategory.Type.EXTREME_HILLS);
        this.add(ModIntegration.terralithLoc("shrubland"), BiomeCategory.Type.LUSH_DESERT);
        this.add(ModIntegration.terralithLoc("siberian_grove"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("siberian_taiga"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.terralithLoc("skylands_autumn"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("skylands_spring"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("skylands_summer"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("skylands_winter"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("skylands"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("snowy_badlands"), BiomeCategory.Type.COLD_DESERT);
        this.add(ModIntegration.terralithLoc("snowy_cherry_grove"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.terralithLoc("snowy_maple_forest"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("snowy_shield"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("steppe"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("stony_spires"), BiomeCategory.Type.EXTREME_HILLS);
        this.add(ModIntegration.terralithLoc("temperate_highlands"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.terralithLoc("tropical_jungle"), BiomeCategory.Type.RAINFOREST);
        this.add(ModIntegration.terralithLoc("valley_clearing"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.terralithLoc("volcanic_crater"), BiomeCategory.Type.VOLCANIC);
        this.add(ModIntegration.terralithLoc("volcanic_peaks"), BiomeCategory.Type.EXTREME_HILLS);
        this.add(ModIntegration.terralithLoc("warm_river"), BiomeCategory.Type.RIVER);
        this.add(ModIntegration.terralithLoc("warped_mesa"), BiomeCategory.Type.MESA);
        this.add(ModIntegration.terralithLoc("white_cliffs"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("white_mesa"), BiomeCategory.Type.MESA);
        this.add(ModIntegration.terralithLoc("windswept_spires"), BiomeCategory.Type.DESERT);
        this.add(ModIntegration.terralithLoc("wintry_forest"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.terralithLoc("wintry_lowlands"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.terralithLoc("yellowstone"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("yosemite_cliffs"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.terralithLoc("yosemite_lowlands"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.regionsLoc("alpha_grove"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.regionsLoc("ancient_delta"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.regionsLoc("arid_mountains"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.regionsLoc("ashen_woodland"), BiomeCategory.Type.VOLCANIC);
        this.add(ModIntegration.regionsLoc("autumnal_maple_forest"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.regionsLoc("bamboo_forest"), BiomeCategory.Type.RAINFOREST);
        this.add(ModIntegration.regionsLoc("baobab_savanna"), BiomeCategory.Type.SAVANNA);
        this.add(ModIntegration.regionsLoc("barley_fields"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.regionsLoc("bayou"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.regionsLoc("bioshroom_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.regionsLoc("blackstone_basin"), BiomeCategory.Type.NETHER);
        this.add(ModIntegration.regionsLoc("blackwood_taiga"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.regionsLoc("boreal_taiga"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.regionsLoc("chalk_cliffs"), BiomeCategory.Type.BEACH);
        this.add(ModIntegration.regionsLoc("clover_plains"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.regionsLoc("cold_boreal_taiga"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.regionsLoc("cold_deciduous_forest"), BiomeCategory.Type.COLD_FOREST);
        this.add(ModIntegration.regionsLoc("cold_river"), BiomeCategory.Type.RIVER);
        this.add(ModIntegration.regionsLoc("deciduous_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.regionsLoc("dry_bushland"), BiomeCategory.Type.SAVANNA);
        this.add(ModIntegration.regionsLoc("eucalyptus_forest"), BiomeCategory.Type.RAINFOREST);
        this.add(ModIntegration.regionsLoc("fen"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.regionsLoc("flower_fields"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.regionsLoc("frozen_pine_taiga"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.regionsLoc("frozen_tundra"), BiomeCategory.Type.ICY);
        this.add(ModIntegration.regionsLoc("fungal_fen"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.regionsLoc("glistering_meadow"), BiomeCategory.Type.NETHER);
        this.add(ModIntegration.regionsLoc("golden_boreal_taiga"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.regionsLoc("grassland"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.regionsLoc("grassy_beach"), BiomeCategory.Type.BEACH);
        this.add(ModIntegration.regionsLoc("gravel_beach"), BiomeCategory.Type.BEACH);
        this.add(ModIntegration.regionsLoc("highland_fields"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.regionsLoc("hyacinth_deeps"), BiomeCategory.Type.DEEP_COLD_OCEAN);
        this.add(ModIntegration.regionsLoc("icy_heights"), BiomeCategory.Type.ICY);
        this.add(ModIntegration.regionsLoc("infernal_holt"), BiomeCategory.Type.NETHER);
        this.add(ModIntegration.regionsLoc("joshua_desert"), BiomeCategory.Type.LUSH_DESERT);
        this.add(ModIntegration.regionsLoc("magnolia_woodland"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.regionsLoc("maple_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.regionsLoc("marsh"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.regionsLoc("mauve_hills"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.regionsLoc("mountains"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.regionsLoc("muddy_river"), BiomeCategory.Type.RIVER);
        this.add(ModIntegration.regionsLoc("mycotoxic_undergrowth"), BiomeCategory.Type.NETHER);
        this.add(ModIntegration.regionsLoc("old_growth_bayou"), BiomeCategory.Type.BOG);
        this.add(ModIntegration.regionsLoc("orchard"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.regionsLoc("outback"), BiomeCategory.Type.SAVANNA);
        this.add(ModIntegration.regionsLoc("pine_slopes"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.regionsLoc("pine_taiga"), BiomeCategory.Type.TAIGA);
        this.add(ModIntegration.regionsLoc("poppy_fields"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.regionsLoc("prairie"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.regionsLoc("prismachasm"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.regionsLoc("pumpkin_fields"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.regionsLoc("rainforest"), BiomeCategory.Type.RAINFOREST);
        this.add(ModIntegration.regionsLoc("redstone_abyss"), BiomeCategory.Type.NETHER);
        this.add(ModIntegration.regionsLoc("redstone_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.regionsLoc("redwoods"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.regionsLoc("rocky_meadow"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.regionsLoc("rocky_reef"), BiomeCategory.Type.LUKEWARM_OCEAN);
        this.add(ModIntegration.regionsLoc("saguaro_desert"), BiomeCategory.Type.LUSH_DESERT);
        this.add(ModIntegration.regionsLoc("scorching_caves"), BiomeCategory.Type.UNDERGROUND);
        this.add(ModIntegration.regionsLoc("shrubland"), BiomeCategory.Type.PLAINS);
        this.add(ModIntegration.regionsLoc("silver_birch_forest"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.regionsLoc("sparse_rainforest"), BiomeCategory.Type.RAINFOREST);
        this.add(ModIntegration.regionsLoc("sparse_redwoods"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.regionsLoc("spires"), BiomeCategory.Type.ICY);
        this.add(ModIntegration.regionsLoc("steppe"), BiomeCategory.Type.DRYLAND);
        this.add(ModIntegration.regionsLoc("temperate_grove"), BiomeCategory.Type.FOREST);
        this.add(ModIntegration.regionsLoc("towering_cliffs"), BiomeCategory.Type.MOUNTAIN);
        this.add(ModIntegration.regionsLoc("tropical_river"), BiomeCategory.Type.RIVER);
        this.add(ModIntegration.regionsLoc("tropics"), BiomeCategory.Type.RAINFOREST);
        this.add(ModIntegration.regionsLoc("willow_forest"), BiomeCategory.Type.FOREST);
    }

    protected void add(ResourceKey<Biome> biomeResourceKey, BiomeCategory.Type type) {
        this.BIOME_CATEGORY_MAP.put(biomeResourceKey.m_135782_(), new BiomeCategory(biomeResourceKey.m_135782_(), type.name()));
    }

    protected void add(ResourceLocation loc, BiomeCategory.Type type) {
        this.BIOME_CATEGORY_MAP.put(loc, new BiomeCategory(loc, type.name()));
    }

    public String m_6055_() {
        return "Homeostatic - Biome Categories";
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) throws IllegalStateException {
        ArrayList<CompletableFuture> recipeList = new ArrayList<CompletableFuture>();
        this.registerBiomeCategories();
        for (Map.Entry<ResourceLocation, BiomeCategory> entry : this.BIOME_CATEGORY_MAP.entrySet()) {
            PackOutput.PathProvider pathProvider = this.getPath(entry.getKey());
            recipeList.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)BiomeCategoryManager.parseBiomeCategory(entry.getValue()), (Path)pathProvider.m_245731_(entry.getKey())));
        }
        return CompletableFuture.allOf((CompletableFuture[])recipeList.toArray(CompletableFuture[]::new));
    }

    private PackOutput.PathProvider getPath(ResourceLocation loc) {
        return this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "environment/biome_category/");
    }
}

