/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.biome.BiomeCategory;
import homeostatic.common.biome.BiomeTypeData;
import homeostatic.common.biome.BiomeTypeDataManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BiomeTypeDataProvider
implements DataProvider {
    private final Map<ResourceLocation, BiomeTypeData> BIOME_TYPES_MAP = new HashMap<ResourceLocation, BiomeTypeData>();
    private final PackOutput packOutput;

    public BiomeTypeDataProvider(@NotNull PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    protected void registerBiomeTypeData() {
        this.add(Homeostatic.loc(BiomeCategory.Type.BOG.toString()), new BiomeTypeData(0.351f, 60.0, 40.0, 10.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.FROZEN_OCEAN.toString()), new BiomeTypeData(0.373f, 20.0, 20.0, 5.0, true));
        this.add(Homeostatic.loc(BiomeCategory.Type.COLD_OCEAN.toString()), new BiomeTypeData(0.373f, 20.0, 20.0, 5.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.COLD_FOREST.toString()), new BiomeTypeData(0.373f, 60.0, 40.0, 12.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.COLD_DESERT.toString()), new BiomeTypeData(0.395f, 20.0, 40.0, 20.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.DEEP_COLD_OCEAN.toString()), new BiomeTypeData(0.44f, 20.0, 20.0, 5.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.ICY.toString()), new BiomeTypeData(0.507f, 20.0, 20.0, 5.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.TAIGA.toString()), new BiomeTypeData(0.507f, 50.0, 40.0, 10.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.OCEAN.toString()), new BiomeTypeData(0.551f, 70.0, 40.0, 10.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.RIVER.toString()), new BiomeTypeData(0.551f, 70.0, 40.0, 10.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.DEEP_LUKEWARM_OCEAN.toString()), new BiomeTypeData(0.596f, 70.0, 40.0, 10.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.EXTREME_HILLS.toString()), new BiomeTypeData(0.618f, 50.0, 40.0, 10.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.MOUNTAIN.toString()), new BiomeTypeData(0.618f, 50.0, 40.0, 10.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.LUKEWARM_OCEAN.toString()), new BiomeTypeData(0.64f, 70.0, 40.0, 10.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.BEACH.toString()), new BiomeTypeData(0.663f, 70.0, 40.0, 10.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.FOREST.toString()), new BiomeTypeData(0.663f, 50.0, 40.0, 12.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.UNDERGROUND.toString()), new BiomeTypeData(0.663f, 40.0, 40.0, 12.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.SWAMP.toString()), new BiomeTypeData(0.685f, 90.0, 40.0, 12.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.MUSHROOM.toString()), new BiomeTypeData(0.685f, 70.0, 40.0, 12.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.WARM_OCEAN.toString()), new BiomeTypeData(0.73f, 70.0, 40.0, 10.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.PLAINS.toString()), new BiomeTypeData(0.774f, 60.0, 40.0, 15.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.MISSING.toString()), new BiomeTypeData(0.774f, 40.0, 40.0, 15.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.LUSH_DESERT.toString()), new BiomeTypeData(0.886f, 60.0, 40.0, 15.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.DRYLAND.toString()), new BiomeTypeData(0.886f, 35.0, 40.0, 15.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.RAINFOREST.toString()), new BiomeTypeData(0.886f, 95.0, 40.0, 15.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.JUNGLE.toString()), new BiomeTypeData(0.997f, 90.0, 40.0, 15.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.VOLCANIC.toString()), new BiomeTypeData(1.04f, 35.0, 40.0, 15.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.DEAD_SEA.toString()), new BiomeTypeData(1.04f, 35.0, 40.0, 15.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.SAVANNA.toString()), new BiomeTypeData(1.108f, 30.0, 40.0, 15.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.MESA.toString()), new BiomeTypeData(1.309f, 20.0, 40.0, 15.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.DESERT.toString()), new BiomeTypeData(1.354f, 20.0, 40.0, 20.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.NONE.toString()), new BiomeTypeData(0.15f, 40.0, 40.0, 0.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.THEEND.toString()), new BiomeTypeData(0.551f, 40.0, 40.0, 0.0, false));
        this.add(Homeostatic.loc(BiomeCategory.Type.NETHER.toString()), new BiomeTypeData(1.666f, 20.0, 40.0, 0.0, false));
    }

    protected void add(ResourceLocation loc, BiomeTypeData biomeTypeData) {
        this.BIOME_TYPES_MAP.put(loc, biomeTypeData);
    }

    @NotNull
    public String m_6055_() {
        return "Homeostatic - Biome Type Data";
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) throws IllegalStateException {
        ArrayList<CompletableFuture> recipeList = new ArrayList<CompletableFuture>();
        this.registerBiomeTypeData();
        for (Map.Entry<ResourceLocation, BiomeTypeData> entry : this.BIOME_TYPES_MAP.entrySet()) {
            PackOutput.PathProvider pathProvider = this.getPath(entry.getKey());
            recipeList.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)BiomeTypeDataManager.parseBiomeData(entry.getValue()), (Path)pathProvider.m_245731_(entry.getKey())));
        }
        return CompletableFuture.allOf((CompletableFuture[])recipeList.toArray(CompletableFuture[]::new));
    }

    private PackOutput.PathProvider getPath(ResourceLocation loc) {
        return this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "environment/biome_type_data/");
    }
}

