/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data.recipe;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import homeostatic.Homeostatic;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.data.AdvancedCookingRecipeBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeProviderBase
implements DataProvider {
    private final PackOutput packOutput;
    public static final ItemStack waterBottle = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);

    protected RecipeProviderBase(@NotNull PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) throws IllegalStateException {
        PackOutput.PathProvider pathProvider = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "recipes");
        PackOutput.PathProvider advancementPathProvider = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "advancements");
        HashSet resourceLocationSet = Sets.newHashSet();
        ArrayList recipeList = new ArrayList();
        this.registerRecipes(recipe -> {
            CompletableFuture<?> recipeAdvancement;
            if (!resourceLocationSet.add(recipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(recipe.m_6445_()));
            }
            recipeList.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)recipe.m_125966_(), (Path)pathProvider.m_245731_(recipe.m_6445_())));
            JsonObject advancement = recipe.m_5860_();
            if (advancement != null && (recipeAdvancement = this.saveAdvancement(cache, (FinishedRecipe)recipe, advancement, advancementPathProvider)) != null) {
                recipeList.add(recipeAdvancement);
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])recipeList.toArray(CompletableFuture[]::new));
    }

    protected abstract void registerRecipes(Consumer<FinishedRecipe> var1);

    @Nullable
    protected CompletableFuture<?> saveAdvancement(CachedOutput cache, FinishedRecipe recipe, JsonObject json, PackOutput.PathProvider path) {
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path.m_245731_(recipe.m_6448_()));
    }

    protected static void specialRecipe(Consumer<FinishedRecipe> consumer, SimpleCraftingRecipeSerializer<?> serializer) {
        ResourceLocation name = BuiltInRegistries.f_256769_.m_7981_(serializer);
        SpecialRecipeBuilder.m_245676_(serializer).m_126359_(consumer, Homeostatic.loc("dynamic/" + Objects.requireNonNull(name).m_135815_()).toString());
    }

    protected static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> pTag) {
        return RecipeProviderBase.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(pTag).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance has(ItemLike pItemLike) {
        return RecipeProviderBase.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{pItemLike}).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, predicates);
    }

    public static ShapedRecipeBuilder leatherFlask() {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)HomeostaticItems.LEATHER_FLASK).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126130_("SPS").m_126130_("L L").m_126130_("LLL").m_126132_("has_leather", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_42454_));
    }

    public static ShapedRecipeBuilder waterFilter() {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)HomeostaticItems.WATER_FILTER).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42414_).m_126130_("P").m_126130_("C").m_126130_("P").m_126132_("has_charcoal", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_42414_));
    }

    public static ShapedRecipeBuilder thermometer() {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)HomeostaticItems.THERMOMETER).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42416_).m_126130_("N").m_126130_("D").m_126130_("I").m_126132_("has_redstone", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_42451_));
    }

    public static ShapelessRecipeBuilder book() {
        return ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)HomeostaticItems.BOOK).m_126209_((ItemLike)Items.f_42329_).m_126145_("books").m_126132_("has_dirt", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_42329_));
    }

    public static AdvancedCookingRecipeBuilder cleanWaterFlaskSmelting() {
        return AdvancedCookingRecipeBuilder.leatherFlaskSmelting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{HomeostaticItems.LEATHER_FLASK}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{HomeostaticItems.LEATHER_FLASK}), 0.15f, 150).unlockedBy("has_leather_flask", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)HomeostaticItems.LEATHER_FLASK));
    }

    public static AdvancedCookingRecipeBuilder cleanWaterFlaskCampfire() {
        return AdvancedCookingRecipeBuilder.campfireLeatherFlaskCooking(Ingredient.m_43929_((ItemLike[])new ItemLike[]{HomeostaticItems.LEATHER_FLASK}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{HomeostaticItems.LEATHER_FLASK}), 0.15f, 200).unlockedBy("has_leather_flask", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)HomeostaticItems.LEATHER_FLASK));
    }

    public static AdvancedCookingRecipeBuilder cleanWaterFlaskSmoking() {
        return AdvancedCookingRecipeBuilder.leatherFlaskSmoking(Ingredient.m_43929_((ItemLike[])new ItemLike[]{HomeostaticItems.LEATHER_FLASK}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{HomeostaticItems.LEATHER_FLASK}), 0.15f, 100).unlockedBy("has_leather_flask", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)HomeostaticItems.LEATHER_FLASK));
    }

    public static AdvancedCookingRecipeBuilder cleanWaterBottleSmelting() {
        return AdvancedCookingRecipeBuilder.waterBottleSmelting(Ingredient.m_43927_((ItemStack[])new ItemStack[]{waterBottle}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{HomeostaticItems.PURIFIED_WATER_BOTTLE}), 0.05f, 75).unlockedBy("has_glass_bottle", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_42590_));
    }

    public static AdvancedCookingRecipeBuilder cleanWaterBottleCampfire() {
        return AdvancedCookingRecipeBuilder.campfireWaterBottleCooking(Ingredient.m_43927_((ItemStack[])new ItemStack[]{waterBottle}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{HomeostaticItems.PURIFIED_WATER_BOTTLE}), 0.05f, 100).unlockedBy("has_glass_bottle", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_42590_));
    }

    public static AdvancedCookingRecipeBuilder cleanWaterBottleSmoking() {
        return AdvancedCookingRecipeBuilder.waterBottleSmoking(Ingredient.m_43927_((ItemStack[])new ItemStack[]{waterBottle}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{HomeostaticItems.PURIFIED_WATER_BOTTLE}), 0.05f, 50).unlockedBy("has_glass_bottle", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_42590_));
    }
}

