/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.platform.Services;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class TemperatureData {
    public float localTemperature;
    public float skinTemperature;
    public float coreTemperature;

    public TemperatureData(float localTemperature, float skinTemperature, float coreTemperature) {
        this.localTemperature = localTemperature;
        this.skinTemperature = skinTemperature;
        this.coreTemperature = coreTemperature;
    }

    public TemperatureData(FriendlyByteBuf buf) {
        this.localTemperature = buf.readFloat();
        this.skinTemperature = buf.readFloat();
        this.coreTemperature = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.localTemperature);
        buf.writeFloat(this.skinTemperature);
        buf.writeFloat(this.coreTemperature);
    }

    public void process(Player player, TemperatureData temperatureData) {
        Services.PLATFORM.getTemperatureData(player).ifPresent(data -> {
            data.setLocalTemperature(temperatureData.localTemperature);
            data.setSkinTemperature(temperatureData.skinTemperature);
            data.setCoreTemperature(temperatureData.coreTemperature);
        });
    }
}

