/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import homeostatic.Homeostatic;
import homeostatic.common.capabilities.ITemperature;
import homeostatic.common.temperature.TemperatureThreshold;
import homeostatic.overlay.Overlay;
import homeostatic.platform.Services;
import homeostatic.util.OverlayHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class EnhancedVisualsOverlay
extends Overlay {
    public static final ResourceLocation HYPERTHERMIA_OVERLAY = Homeostatic.loc("textures/gui/hyperthermia.png");
    private final LastTick lastTick = new LastTick();

    @Override
    public void render(GuiGraphics guiGraphics, Minecraft mc, @Nullable BlockPos pos, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        RenderSystem.enableBlend();
        Services.PLATFORM.getTemperatureData((Player)player).ifPresent(arg_0 -> this.lambda$render$0((Player)player, scaledWidth, scaledHeight, arg_0));
    }

    private /* synthetic */ void lambda$render$0(Player player, int scaledWidth, int scaledHeight, ITemperature data) {
        float intensity;
        if (data.getSkinTemperature() > TemperatureThreshold.SCALDING_WARNING.temperature && this.lastTick.update(player, intensity = 1.0f - (data.getSkinTemperature() - TemperatureThreshold.SCALDING_WARNING.temperature) * 10.0f)) {
            player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20227_(1.0) - 0.5, player.m_20189_(), 0.0, 9.0E-6, 0.0);
            if (Homeostatic.RANDOM.nextInt(80) == 0) {
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, player.m_20185_(), player.m_20227_(1.0) - 0.5, player.m_20189_(), 0.0, 6.0E-5, 0.0);
            }
        }
        if (data.getCoreTemperature() > TemperatureThreshold.WARNING_HIGH.temperature) {
            float alpha = 0.1f + (data.getCoreTemperature() - TemperatureThreshold.WARNING_HIGH.temperature) * 10.0f;
            OverlayHelper.renderTexture(HYPERTHERMIA_OVERLAY, scaledWidth, scaledHeight, alpha);
        }
    }

    private static class LastTick {
        private long lastTick = 0L;

        private LastTick() {
        }

        private boolean update(Player player, float intensity) {
            if ((float)player.f_19797_ >= (float)this.lastTick + 20.0f * intensity) {
                this.lastTick = player.f_19797_;
                return true;
            }
            if ((long)player.f_19797_ < this.lastTick) {
                this.lastTick = player.f_19797_;
                return false;
            }
            return false;
        }
    }
}

