/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.config.ConfigHandler;
import homeostatic.overlay.EnhancedVisualsOverlay;
import homeostatic.overlay.HydrationOverlay;
import homeostatic.overlay.Overlay;
import homeostatic.overlay.TemperatureGlobeOverlay;
import homeostatic.overlay.TemperatureInfo;
import homeostatic.overlay.WaterHud;
import homeostatic.overlay.WetnessOverlay;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;

public class OverlayManager {
    public static final OverlayManager INSTANCE = new OverlayManager();
    public final WaterHud waterHud = new WaterHud();
    public final WetnessOverlay wetnessOverlay = new WetnessOverlay();
    public final TemperatureGlobeOverlay temperatureGlobeOverlay = new TemperatureGlobeOverlay();
    public final TemperatureInfo temperatureInfo = new TemperatureInfo();
    public final EnhancedVisualsOverlay enhancedVisualsOverlay = new EnhancedVisualsOverlay();
    public final HydrationOverlay hydrationOverlay = new HydrationOverlay();

    private OverlayManager() {
    }

    public void render(GuiGraphics guiGraphics, Overlay overlay, boolean scaled, int rightHeight) {
        PoseStack matrix = guiGraphics.m_280168_();
        Minecraft mc = Minecraft.m_91087_();
        BlockPos pos = Objects.requireNonNull(mc.m_91288_()).m_20183_();
        if (mc.f_91073_ != null && mc.f_91073_.m_46749_(pos)) {
            int scaledHeight;
            int scaledWidth;
            if (scaled) {
                float scale = (float)ConfigHandler.Client.scale();
                scaledWidth = (int)((float)mc.m_91268_().m_85445_() / scale);
                scaledHeight = (int)((float)mc.m_91268_().m_85446_() / scale);
                matrix.m_85836_();
                matrix.m_85841_(scale, scale, scale);
            } else {
                scaledWidth = mc.m_91268_().m_85445_();
                scaledHeight = mc.m_91268_().m_85446_() - rightHeight;
                matrix.m_85836_();
            }
            overlay.render(guiGraphics, mc, pos, scaledWidth, scaledHeight);
            matrix.m_85849_();
        }
    }

    public void renderOverlay(GuiGraphics guiGraphics) {
        this.render(guiGraphics, this.temperatureInfo, true, 0);
    }

    public void renderWaterOverlay(GuiGraphics guiGraphics, int rightHeight) {
        if (ConfigHandler.Client.forceWaterBarPosition()) {
            rightHeight = 0;
        }
        this.render(guiGraphics, this.waterHud, false, rightHeight);
        this.render(guiGraphics, this.wetnessOverlay, false, 0);
    }

    public void renderTemperatureOverlay(GuiGraphics guiGraphics) {
        this.render(guiGraphics, this.temperatureGlobeOverlay, false, 0);
    }

    public void renderEnhancedVisualsOverlay(GuiGraphics guiGraphics) {
        this.render(guiGraphics, this.enhancedVisualsOverlay, false, 0);
    }

    public void renderHydrationOverlay(GuiGraphics guiGraphics, int rightHeight) {
        this.render(guiGraphics, this.hydrationOverlay, false, rightHeight);
    }
}

