/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data.recipe;

import homeostatic.Homeostatic;
import homeostatic.common.recipe.ArmorEnhancement;
import homeostatic.common.recipe.HelmetThermometer;
import homeostatic.common.recipe.HomeostaticRecipes;
import homeostatic.common.recipe.PurifiedLeatherFlask;
import homeostatic.common.recipe.RemoveArmorEnhancement;
import homeostatic.data.recipe.RecipeProviderBase;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class CommonRecipeProvider
extends RecipeProvider {
    public CommonRecipeProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registryFuture) {
        super(packOutput, registryFuture);
    }

    public void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        RecipeProviderBase.specialRecipe(recipeOutput, (SimpleCraftingRecipeSerializer)HomeostaticRecipes.ARMOR_ENHANCEMENT_SERIALIZER, ArmorEnhancement::new);
        RecipeProviderBase.specialRecipe(recipeOutput, (SimpleCraftingRecipeSerializer)HomeostaticRecipes.PURIFIED_LEATHER_FLASK_SERIALIZER, PurifiedLeatherFlask::new);
        RecipeProviderBase.specialRecipe(recipeOutput, (SimpleCraftingRecipeSerializer)HomeostaticRecipes.HELMET_THERMOMETER_SERIALIZER, HelmetThermometer::new);
        RecipeProviderBase.specialRecipe(recipeOutput, (SimpleCraftingRecipeSerializer)HomeostaticRecipes.REMOVE_ARMOR_ENHANCEMENT_SERIALIZER, RemoveArmorEnhancement::new);
        RecipeProviderBase.cleanWaterFlaskSmelting().save(recipeOutput, Homeostatic.prefix("furnace_purified_leather_flask"));
        RecipeProviderBase.cleanWaterFlaskCampfire().save(recipeOutput, Homeostatic.prefix("campfire_purified_leather_flask"));
        RecipeProviderBase.cleanWaterFlaskSmoking().save(recipeOutput, Homeostatic.prefix("smoking_purified_leather_flask"));
        RecipeProviderBase.leatherFlask().save(recipeOutput);
        RecipeProviderBase.waterFilter().save(recipeOutput);
        RecipeProviderBase.thermometer().save(recipeOutput);
        RecipeProviderBase.cleanWaterBottleSmelting().save(recipeOutput, Homeostatic.prefix("furnace_purified_water_bottle"));
        RecipeProviderBase.cleanWaterBottleCampfire().save(recipeOutput, Homeostatic.prefix("campfire_purified_water_bottle"));
        RecipeProviderBase.cleanWaterBottleSmoking().save(recipeOutput, Homeostatic.prefix("smoking_purified_water_bottle"));
        RecipeProviderBase.book().save(recipeOutput, Homeostatic.prefix("book_from_dirt"));
    }
}

