/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.mixin;

import homeostatic.event.ClientPlayerEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Nullable
    public HitResult hitResult;
    @Shadow
    @Nullable
    public MultiPlayerGameMode gameMode;

    @Inject(method={"startUseItem"}, at={@At(value="HEAD")})
    private void homeostatic$rightClickAir(CallbackInfo ci) {
        if (this.gameMode != null && !this.gameMode.isDestroying() && this.player != null && !this.player.isHandsBusy()) {
            for (InteractionHand interactionHand : InteractionHand.values()) {
                ItemStack itemstack = this.player.getItemInHand(interactionHand);
                boolean drinkWater = false;
                if (this.hitResult != null) {
                    switch (this.hitResult.getType()) {
                        case BLOCK: {
                            drinkWater = true;
                        }
                    }
                }
                if (!drinkWater && itemstack.isEmpty() && (this.hitResult == null || this.hitResult.getType() == HitResult.Type.MISS)) {
                    drinkWater = true;
                }
                if (!drinkWater) continue;
                ClientPlayerEventHandler.drinkWater((Player)this.player, (LevelAccessor)this.player.level(), interactionHand);
            }
        }
    }
}

