/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.fluid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.fluid.DrinkingFluid;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class DrinkingFluidManager
extends SimpleJsonResourceReloadListener<JsonElement> {
    private static final Map<Fluid, DrinkingFluid> FLUIDS = new HashMap<Fluid, DrinkingFluid>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DrinkingFluid.class, (Object)new DrinkingFluid.Serializer()).create();

    public DrinkingFluidManager() {
        super(ExtraCodecs.JSON, FileToIdConverter.json((String)"environment/fluids"));
    }

    public static JsonElement parseDrinkingFluid(DrinkingFluid drinkingFluid) {
        return GSON.toJsonTree((Object)drinkingFluid);
    }

    public static DrinkingFluid get(Fluid fluid) {
        return FLUIDS.get(fluid);
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        FLUIDS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            try {
                DrinkingFluid drinkingFluid = (DrinkingFluid)GSON.fromJson(entry.getValue(), DrinkingFluid.class);
                Optional fluid = BuiltInRegistries.FLUID.get(drinkingFluid.loc());
                fluid.ifPresent(fluidReference -> FLUIDS.put((Fluid)fluidReference.value(), drinkingFluid));
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse drinking fluid {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} drinking fluids", (Object)FLUIDS.size());
    }
}

