/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.item.IItemStackFluid;
import homeostatic.platform.Services;
import homeostatic.util.WaterHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class WaterContainerItem
extends Item
implements IItemStackFluid {
    protected final int capacity;
    protected final int uses;

    public WaterContainerItem(Item.Properties properties, int capacity, int uses) {
        super(properties.durability(capacity));
        this.capacity = capacity;
        this.uses = uses;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getUses() {
        return this.uses;
    }

    public int getSingleUse() {
        return this.capacity / this.uses;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult hitResult = WaterContainerItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos pos = hitResult.getBlockPos();
        BlockState blockState = level.getBlockState(pos);
        Fluid targetFluid = blockState.getFluidState().getType();
        Optional<FluidInfo> fluidInfoOptional = Services.PLATFORM.getFluidInfo(stack);
        if (fluidInfoOptional.isEmpty()) {
            return InteractionResult.FAIL;
        }
        FluidInfo fluidInfo = fluidInfoOptional.get();
        boolean isEmpty = fluidInfo.isEmpty();
        if ((isEmpty || fluidInfo.fluid().isSame(targetFluid)) && fluidInfo.amount() != (long)this.capacity) {
            BucketPickup bucketPickup;
            Block block;
            if (targetFluid == Fluids.WATER) {
                return InteractionResult.SUCCESS.heldItemTransformedTo(this.getFilledItem(stack, player, targetFluid, this.capacity));
            }
            if (WaterHelper.getFluidHydration(targetFluid) != null && (block = blockState.getBlock()) instanceof BucketPickup && !(bucketPickup = (BucketPickup)block).pickupBlock((LivingEntity)player, (LevelAccessor)level, pos, blockState).isEmpty()) {
                return InteractionResult.SUCCESS.heldItemTransformedTo(this.getFilledItem(stack, player, targetFluid, this.capacity));
            }
        }
        if (!isEmpty && this.canDrink(player, fluidInfo)) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            CriteriaTriggers.CONSUME_ITEM.trigger(sp, stack);
        }
        return Services.PLATFORM.drainFluid(stack, this.getCapacity() / this.getUses());
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay tooltipDisplay, @NotNull Consumer<Component> components, @NotNull TooltipFlag flag) {
        MutableComponent textComponent = Component.translatable((String)"tooltip.water_container.empty").setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY));
        Optional<FluidInfo> fluidInfoOptional = Services.PLATFORM.getFluidInfo(stack);
        if (fluidInfoOptional.isPresent() && fluidInfoOptional.get().amount() > 0L) {
            textComponent = Services.PLATFORM.getDisplayName(fluidInfoOptional.get().fluid());
            long amount = fluidInfoOptional.get().amount();
            components.accept((Component)Component.translatable((String)(textComponent.getString() + String.format(": %d uses.", amount / (long)this.getSingleUse()))).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
        } else {
            components.accept((Component)textComponent);
        }
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 32;
    }

    @NotNull
    public ItemUseAnimation getUseAnimation(@NotNull ItemStack stack) {
        return ItemUseAnimation.DRINK;
    }

    public ItemStack getFilledItem(ItemStack stack, Player player, Fluid fluid, int amount) {
        ItemStack copy = WaterHelper.getFilledItem(stack, fluid, amount);
        player.playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return copy;
    }

    public boolean canDrink(Player player, FluidInfo fluidInfo) {
        AtomicBoolean canDrink = new AtomicBoolean(WaterHelper.getFluidHydration(fluidInfo.fluid()) != null && fluidInfo.amount() >= (long)this.getSingleUse());
        Services.PLATFORM.getWaterCapabilty(player).ifPresent(data -> canDrink.set(canDrink.get() && data.getWaterLevel() < 20));
        return canDrink.get();
    }
}

