/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.recipe;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import homeostatic.common.component.HomeostaticComponents;
import homeostatic.common.recipe.HomeostaticRecipes;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RemoveArmorEnhancement
extends CustomRecipe {
    public RemoveArmorEnhancement(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput craftingInput, @NotNull Level level) {
        Pair<ItemStack, ItemStack> check = this.checkContainer(craftingInput);
        ItemStack armor = (ItemStack)check.getFirst();
        ItemStack removalItem = (ItemStack)check.getSecond();
        return removalItem != null && armor != null;
    }

    public ItemStack assemble(@NotNull CraftingInput craftingInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        Pair<ItemStack, ItemStack> check = this.checkContainer(craftingInput);
        ItemStack armorCopy = ((ItemStack)check.getFirst()).copy();
        ItemStack removalItem = (ItemStack)check.getSecond();
        CompoundTag tags = ((CustomData)armorCopy.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
        boolean save = false;
        if (removalItem.is(Items.SHEARS)) {
            if (tags.contains("insulation")) {
                save = true;
                tags.remove("insulation");
            }
        } else if (removalItem.is(Items.LAVA_BUCKET)) {
            if (tags.contains("waterproof")) {
                save = true;
                tags.remove("waterproof");
            }
        } else if (removalItem.is(Items.WATER_BUCKET) && tags.contains("radiation_protection")) {
            save = true;
            tags.remove("radiation_protection");
        }
        if (save) {
            armorCopy.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)tags));
        }
        return armorCopy;
    }

    public RecipeSerializer<RemoveArmorEnhancement> getSerializer() {
        return HomeostaticRecipes.REMOVE_ARMOR_ENHANCEMENT_SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput craftingInput) {
        NonNullList nonnulllist = NonNullList.withSize((int)craftingInput.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack stack = craftingInput.getItem(i);
            if (stack.is(Items.SHEARS)) {
                nonnulllist.set(i, (Object)stack.getItem().getCraftingRemainder());
                continue;
            }
            if (!stack.is(Items.WATER_BUCKET) && !stack.is(Items.LAVA_BUCKET)) continue;
            ItemStack bucket = new ItemStack((ItemLike)Items.BUCKET);
            nonnulllist.set(i, (Object)bucket);
        }
        return nonnulllist;
    }

    public Pair<ItemStack, ItemStack> checkContainer(CraftingInput craftingInput) {
        ArrayList ingredients = Lists.newArrayList();
        ItemStack removalItem = null;
        ItemStack armor = null;
        boolean hasInsulation = false;
        boolean hasWaterproof = false;
        boolean hasRadiation = false;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack ingredient = craftingInput.getItem(i);
            if (ingredient.is(Items.SHEARS) && !hasWaterproof && !hasRadiation) {
                hasInsulation = true;
                removalItem = ingredient;
                ingredients.add(ingredient);
                continue;
            }
            if (ingredient.is(Items.LAVA_BUCKET) && !hasInsulation && !hasRadiation) {
                hasWaterproof = true;
                removalItem = ingredient;
                ingredients.add(ingredient);
                continue;
            }
            if (ingredient.is(Items.WATER_BUCKET) && !hasWaterproof && !hasInsulation) {
                hasRadiation = true;
                removalItem = ingredient;
                ingredients.add(ingredient);
                continue;
            }
            if (ingredient.get(DataComponents.EQUIPPABLE) == null) continue;
            armor = ingredient;
        }
        if (ingredients.size() != 1) {
            removalItem = null;
        }
        return Pair.of(armor, removalItem);
    }
}

