/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.temperature;

import homeostatic.common.TagManager;
import homeostatic.common.block.BlockRadiation;
import homeostatic.common.block.BlockRadiationManager;
import homeostatic.common.component.HomeostaticComponents;
import homeostatic.common.temperature.EnvironmentInfo;
import homeostatic.common.temperature.TemperatureRange;
import homeostatic.config.ConfigHandler;
import homeostatic.util.VecMath;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class Environment {
    public static final float PARITY = TemperatureRange.PARITY.temperature;
    public static final float PARITY_LOW = TemperatureRange.PARITY_LOW.temperature;
    public static final float PARITY_HIGH = TemperatureRange.PARITY_HIGH.temperature;
    public static final float HOT = TemperatureRange.HOT.temperature;
    public static final float EXTREME_HEAT = TemperatureRange.EXTREME_HEAT.temperature;
    public static final float EXTREME_COLD = TemperatureRange.EXTREME_COLD.temperature;

    public static EnvironmentInfo get(ServerLevel world, ServerPlayer sp) {
        double radiation = 0.0;
        double waterVolume = 0.0;
        double waterBlocks = 0.0;
        double totalBlocks = 0.0;
        AtomicReference<Double> radiationReduction = new AtomicReference<Double>(1.0);
        HashMap<ChunkPos, LevelChunk> chunkMap = new HashMap<ChunkPos, LevelChunk>();
        BlockPos pos = sp.blockPosition();
        Vec3 spPos = sp.getEyePosition(1.0f);
        BlockPos eyePos = new BlockPos((int)spPos.x(), (int)spPos.y(), (int)spPos.z());
        ResourceKey worldKey = world.dimension();
        MobEffectInstance effectInstance = sp.getEffect(MobEffects.FIRE_RESISTANCE);
        boolean inOverworld = worldKey.location().toString().contains(BuiltinDimensionTypes.OVERWORLD.location().toString());
        boolean isSubmerged = sp.isUnderWater() && sp.isInWater() && sp.isInWaterOrRain();
        boolean isSheltered = true;
        boolean isUnderground = true;
        if (!inOverworld) {
            isUnderground = false;
            isSheltered = false;
        }
        if (isSubmerged) {
            isSheltered = false;
        }
        for (EquipmentSlot slot : EquipmentSlotGroup.ARMOR) {
            CompoundTag tags;
            ItemStack armor = sp.getItemBySlot(slot);
            if (armor.isEmpty() || !(tags = ((CustomData)armor.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag()).contains("radiation_protection") && !armor.is(TagManager.Items.RADIATION_PROTECTED_ARMOR)) continue;
            radiationReduction.updateAndGet(v -> v - (double)ConfigHandler.Common.getRadiationReductionPercent());
        }
        for (int x = -12; x <= 12; ++x) {
            for (int z = -12; z <= 12; ++z) {
                if (isSheltered && x <= 2 && x >= -2 && z <= 2 && z >= -2) {
                    isSheltered = !world.canSeeSky(eyePos.offset(x, 0, z).above());
                }
                for (int y = -3; y <= 11; ++y) {
                    BlockRadiation blockRadiation;
                    PalettedContainer palette;
                    ChunkPos chunkPos = new ChunkPos(pos.getX() + x >> 4, pos.getZ() + z >> 4);
                    LevelChunk chunk = Environment.getChunk((Level)world, chunkPos, chunkMap);
                    if (chunk == null) continue;
                    BlockPos blockpos = pos.offset(x, y, z);
                    try {
                        palette = chunk.getSection((blockpos.getY() >> 4) - chunk.getMinSectionY()).getStates();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    BlockState state = (BlockState)palette.get(blockpos.getX() & 0xF, blockpos.getY() & 0xF, blockpos.getZ() & 0xF);
                    boolean isWater = state.is(Blocks.WATER);
                    if (isUnderground && y >= 0 && !isWater) {
                        boolean bl = isUnderground = !world.canSeeSky(eyePos.offset(x, y, z).above());
                    }
                    if (x <= 5 && x >= -5 && y <= 5 && z <= 5 && z >= -5) {
                        totalBlocks += 1.0;
                        if (isWater) {
                            waterBlocks += 1.0;
                        }
                    }
                    if (state.isAir() || y > 3 || effectInstance != null || (blockRadiation = BlockRadiationManager.getBlockRadiation(state.getBlock())) == null) continue;
                    boolean hasRadiation = true;
                    if (state.hasProperty((Property)BlockStateProperties.LIT)) {
                        hasRadiation = (Boolean)state.getValue((Property)BlockStateProperties.LIT);
                    }
                    if (hasRadiation && Objects.requireNonNull(state.getBlock().toString()).contains("campfire")) {
                        for (int i = 1; i <= 5; ++i) {
                            if (!hasRadiation || !world.getBlockState(blockpos.above(i)).is(BlockTags.BEEHIVES)) continue;
                            hasRadiation = false;
                        }
                    }
                    if (!hasRadiation) continue;
                    Vec3 vPos = new Vec3((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5);
                    double distance = VecMath.getDistance(sp, new Vector3d(vPos.x, vPos.y, vPos.z));
                    boolean obscured = VecMath.isBlockObscured(sp, vPos);
                    if (!state.getFluidState().isEmpty()) {
                        double amount = (double)state.getFluidState().getAmount() / 8.0;
                        radiation += blockRadiation.getBlockRadiation(state, distance, obscured, amount, y);
                        continue;
                    }
                    radiation += blockRadiation.getBlockRadiation(state, distance, obscured, y);
                }
            }
        }
        waterVolume = waterBlocks == 0.0 ? 0.0 : waterBlocks / totalBlocks;
        return new EnvironmentInfo(isUnderground, isSheltered, radiation *= radiationReduction.get().doubleValue(), waterVolume);
    }

    private static LevelChunk getChunk(Level world, ChunkPos pos, Map<ChunkPos, LevelChunk> chunks) {
        LevelChunk chunk;
        ChunkPos chunkPos = new ChunkPos(pos.x, pos.z);
        if (chunks.containsKey(chunkPos)) {
            chunk = chunks.get(chunkPos);
        } else {
            chunk = world.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
            chunks.put(chunkPos, chunk);
        }
        return chunk;
    }
}

