/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.event;

import homeostatic.platform.Services;
import homeostatic.util.ClientGameModeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ClientPlayerEventHandler {
    public static void drinkWater(Player player, LevelAccessor level, InteractionHand hand) {
        if (hand != InteractionHand.OFF_HAND || player.getPose() != Pose.CROUCHING || !player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() || !ClientGameModeHelper.shouldLoad()) {
            return;
        }
        HitResult hitresult = player.pick(2.0, 0.0f, true);
        BlockPos pos = ((BlockHitResult)hitresult).getBlockPos();
        if (hitresult.getType() == HitResult.Type.BLOCK && level.getFluidState(pos).getType() == Fluids.WATER) {
            Services.PLATFORM.getWaterCapabilty(player).ifPresent(data -> {
                if (data.getWaterLevel() < 20) {
                    player.level().playSound((Entity)player, pos, (SoundEvent)SoundEvents.GENERIC_DRINK.value(), SoundSource.PLAYERS, 0.4f, 1.0f);
                    Services.CLIENT_PLATFORM.sendDrinkWaterPacket(player);
                }
            });
        }
    }
}

