/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.event;

import homeostatic.Homeostatic;
import homeostatic.common.biome.BiomeCategory;
import homeostatic.common.biome.BiomeCategoryManager;
import homeostatic.common.biome.BiomeTypeData;
import homeostatic.common.biome.BiomeTypeDataManager;
import homeostatic.common.block.BlockRadiationManager;
import homeostatic.common.fluid.DrinkingFluidManager;
import homeostatic.common.item.DrinkableItemManager;
import homeostatic.event.PlayerEventHandler;
import homeostatic.util.RegistryHelper;
import homeostatic.util.WaterHelper;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class ServerEventListener {
    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Player player;
        Player player2 = player = event.getEntity() instanceof Player ? (Player)event.getEntity() : null;
        if (player != null && !player.level().isClientSide()) {
            PlayerEventHandler.onEntityJoinLevel((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(PlayerTickEvent.Pre event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        if (!event.getEntity().level().isClientSide()) {
            PlayerEventHandler.onPlayerTickEvent((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player player = event.getEntity();
        if (!player.level().isClientSide()) {
            PlayerEventHandler.onPlayerRespawn((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onFinishUsingItem(LivingEntityUseItemEvent.Finish event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).level().isClientSide()) {
            ItemStack stack = event.getItem();
            ServerPlayer sp = (ServerPlayer)player;
            WaterHelper.drink(sp, stack, true);
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        PlayerEventHandler.onEquipmentChange(event.getEntity(), event.getSlot(), event.getFrom(), event.getTo());
    }

    @SubscribeEvent
    public static void onResourceReload(AddServerReloadListenersEvent event) {
        event.addListener(Homeostatic.prefix("biome_category"), (PreparableReloadListener)new BiomeCategoryManager());
        event.addListener(Homeostatic.prefix("biome_type_data"), (PreparableReloadListener)new BiomeTypeDataManager());
        event.addListener(Homeostatic.prefix("block_radiation"), (PreparableReloadListener)new BlockRadiationManager());
        event.addListener(Homeostatic.prefix("fluids"), (PreparableReloadListener)new DrinkingFluidManager());
        event.addListener(Homeostatic.prefix("drinkable"), (PreparableReloadListener)new DrinkableItemManager());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void serverStart(ServerStartedEvent event) {
        Registry biomeRegistry = RegistryHelper.getRegistry(event.getServer(), Registries.BIOME);
        for (Map.Entry entry : biomeRegistry.entrySet()) {
            ResourceKey biomeResourceKey = (ResourceKey)entry.getKey();
            ResourceLocation biomeName = biomeResourceKey.location();
            Holder biomeHolder = biomeRegistry.wrapAsHolder((Object)((Biome)biomeRegistry.getValueOrThrow(biomeResourceKey)));
            BiomeCategory.Type biomeCategory = BiomeCategoryManager.getBiomeCategory((Holder<Biome>)biomeHolder);
            BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome((Holder<Biome>)biomeHolder);
            Biome biome = (Biome)biomeHolder.value();
            Biome.Precipitation precipitation = ServerEventListener.getPrecipitation(biome);
            String temperatureModifier = biomeTypeData.isFrozen() ? "FROZEN" : "NONE";
            float dayNightOffset = biomeTypeData.getDayNightOffset(precipitation);
            double humidity = biomeTypeData.getHumidity(precipitation);
            if (biomeName.toString().equals("terrablender:deferred_placeholder")) continue;
            if (biomeCategory == BiomeCategory.Type.MISSING) {
                Homeostatic.LOGGER.warn("Missing biome in registry, will set to neutral temperature for: {}", (Object)biomeName);
            }
            Homeostatic.LOGGER.debug("Biome: " + String.valueOf(biomeName) + "\nprecipitation_type=" + String.valueOf(precipitation) + "\ntemperature=" + biomeTypeData.getTemperature(precipitation) + "\ntemperatureModifier=" + temperatureModifier + "\ndownfall=" + biome.getModifiedClimateSettings().downfall() + "\ndayNightOffset=" + dayNightOffset + "\nhumidity=" + humidity + "\nbiomeCategory=" + String.valueOf((Object)biomeCategory));
        }
    }

    private static Biome.Precipitation getPrecipitation(Biome biome) {
        if (!biome.hasPrecipitation()) {
            return Biome.Precipitation.NONE;
        }
        return biome.getBaseTemperature() <= 0.15f ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }
}

