/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.integrations;

import com.mojang.datafixers.util.Pair;
import homeostatic.Homeostatic;
import homeostatic.common.component.HomeostaticComponents;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.util.RegistryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ItemLike;

public final class HelmetThermometerRecipeMaker {
    public static List<Pair<ItemStack, RecipeHolder<CraftingRecipe>>> createRecipes(String plugin) {
        String group = plugin + ".helmet";
        ArrayList<Pair<ItemStack, RecipeHolder<CraftingRecipe>>> recipes = new ArrayList<Pair<ItemStack, RecipeHolder<CraftingRecipe>>>();
        Ingredient thermometer = Ingredient.of((ItemLike)HomeostaticItems.THERMOMETER);
        RegistryHelper.getRegistry(Registries.ITEM).stream().filter(armorItem -> armorItem.components().has(DataComponents.EQUIPPABLE)).filter(armorItem -> Objects.requireNonNull((Equippable)armorItem.components().get(DataComponents.EQUIPPABLE)).slot() == EquipmentSlot.HEAD).forEach(armorItem -> {
            ItemStack armorStack = new ItemStack((ItemLike)armorItem);
            Ingredient baseArmorIngredient = Ingredient.of((ItemLike)armorItem.asItem());
            CompoundTag tag = ((CustomData)armorStack.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
            NonNullList recipeInputs = NonNullList.of(null, (Object[])new Ingredient[]{baseArmorIngredient, thermometer});
            tag.putBoolean("thermometer", true);
            armorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)tag));
            recipes.add(Pair.of((Object)armorStack, (Object)new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Homeostatic.prefix(group + ".thermometer")), (Recipe)new ShapelessRecipe(group, CraftingBookCategory.EQUIPMENT, armorStack, (List)recipeInputs))));
        });
        return recipes;
    }
}

