/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.integrations.jei;

import homeostatic.Homeostatic;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.recipe.ArmorEnhancement;
import homeostatic.common.recipe.CampfirePurifiedLeatherFlask;
import homeostatic.common.recipe.CampfirePurifiedWaterBottle;
import homeostatic.common.recipe.HelmetThermometer;
import homeostatic.common.recipe.SmeltingPurifiedLeatherFlask;
import homeostatic.common.recipe.SmeltingPurifiedWaterBottle;
import homeostatic.common.recipe.SmokingPurifiedLeatherFlask;
import homeostatic.common.recipe.SmokingPurifiedWaterBottle;
import homeostatic.config.ConfigHandler;
import homeostatic.integrations.ArmorEnhancementRecipeMaker;
import homeostatic.integrations.CampfireRecipeMaker;
import homeostatic.integrations.HelmetThermometerRecipeMaker;
import homeostatic.integrations.SmeltingRecipeMaker;
import homeostatic.integrations.SmokerRecipeMaker;
import homeostatic.integrations.WaterFilterRecipeMaker;
import homeostatic.integrations.jei.Recipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.common.Internal;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return Homeostatic.prefix("jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeMap clientSyncedRecipes = Internal.getClientSyncedRecipes();
        if (clientSyncedRecipes.values().isEmpty()) {
            Homeostatic.LOGGER.error("JEI Recipe Registration failed: No synced recipes");
            return;
        }
        Recipes recipes = new Recipes(clientSyncedRecipes);
        List<RecipeHolder<CraftingRecipe>> craftingRecipes = recipes.getCraftingRecipes();
        List<RecipeHolder<CraftingRecipe>> armorEnhancementRecipes = JEIPlugin.addArmorCraftingRecipes(craftingRecipes);
        List<RecipeHolder<CampfireCookingRecipe>> allCampfireRecipes = recipes.getCampfireCookingRecipes();
        List<RecipeHolder<CampfireCookingRecipe>> purifiedWaterCampfireRecipes = JEIPlugin.addCampfireRecipes(allCampfireRecipes);
        List<RecipeHolder<SmokingRecipe>> allSmokingRecipes = recipes.getSmokingRecipes();
        List<RecipeHolder<SmokingRecipe>> purifiedWaterSmokingRecipes = JEIPlugin.addSmokingRecipes(allSmokingRecipes);
        List<RecipeHolder<SmeltingRecipe>> allSmeltingRecipes = recipes.getSmeltingRecipes();
        List<RecipeHolder<SmeltingRecipe>> purifiedWaterSmeltingRecipes = JEIPlugin.addSmeltingRecipes(allSmeltingRecipes);
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, armorEnhancementRecipes);
        ArrayList waterFilterRecipes = new ArrayList();
        WaterFilterRecipeMaker.getFilterCraftingRecipes("jei").forEach(pair -> waterFilterRecipes.add((RecipeHolder)pair.getSecond()));
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, waterFilterRecipes);
        registration.addRecipes((IRecipeType)RecipeTypes.CAMPFIRE_COOKING, purifiedWaterCampfireRecipes);
        registration.addRecipes((IRecipeType)RecipeTypes.SMOKING, purifiedWaterSmokingRecipes);
        registration.addRecipes((IRecipeType)RecipeTypes.SMELTING, purifiedWaterSmeltingRecipes);
        if (!ConfigHandler.Common.requireThermometer()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)HomeostaticItems.THERMOMETER)));
        }
    }

    private static List<RecipeHolder<CraftingRecipe>> addArmorCraftingRecipes(List<RecipeHolder<CraftingRecipe>> craftingRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        ArrayList recipes = new ArrayList();
        ArrayList helmetThermometerRecipes = new ArrayList();
        ArmorEnhancementRecipeMaker.createRecipes("jei").forEach(pair -> recipes.add((RecipeHolder)pair.getSecond()));
        replacers.put(ArmorEnhancement.class, () -> recipes);
        if (ConfigHandler.Common.requireThermometer()) {
            HelmetThermometerRecipeMaker.createRecipes("jei").forEach(pair -> helmetThermometerRecipes.add((RecipeHolder)pair.getSecond()));
            replacers.put(HelmetThermometer.class, () -> helmetThermometerRecipes);
        }
        return craftingRecipes.stream().map(RecipeHolder::value).map(CraftingRecipe::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                return ((List)supplier.get()).stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new RecipeHolder[0]);
            }
        }).toList();
    }

    private static List<RecipeHolder<CampfireCookingRecipe>> addCampfireRecipes(List<RecipeHolder<CampfireCookingRecipe>> campfireRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(CampfirePurifiedLeatherFlask.class, () -> CampfireRecipeMaker.createFlaskRecipes("jei"));
        replacers.put(CampfirePurifiedWaterBottle.class, () -> CampfireRecipeMaker.createWaterBottleRecipes("jei"));
        return campfireRecipes.stream().map(RecipeHolder::value).map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                return ((List)supplier.get()).stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new RecipeHolder[0]);
            }
        }).toList();
    }

    private static List<RecipeHolder<SmokingRecipe>> addSmokingRecipes(List<RecipeHolder<SmokingRecipe>> smokingRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(SmokingPurifiedLeatherFlask.class, () -> SmokerRecipeMaker.createFlaskRecipes("jei"));
        replacers.put(SmokingPurifiedWaterBottle.class, () -> SmokerRecipeMaker.createWaterBottleRecipes("jei"));
        return smokingRecipes.stream().map(RecipeHolder::value).map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                return ((List)supplier.get()).stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new RecipeHolder[0]);
            }
        }).toList();
    }

    private static List<RecipeHolder<SmeltingRecipe>> addSmeltingRecipes(List<RecipeHolder<SmeltingRecipe>> smeltingRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(SmeltingPurifiedLeatherFlask.class, () -> SmeltingRecipeMaker.createFlaskRecipes("jei"));
        replacers.put(SmeltingPurifiedWaterBottle.class, () -> SmeltingRecipeMaker.createWaterBottleRecipes("jei"));
        return smeltingRecipes.stream().map(RecipeHolder::value).map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                return ((List)supplier.get()).stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new RecipeHolder[0]);
            }
        }).toList();
    }
}

