/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import homeostatic.common.TagManager;
import homeostatic.common.component.HomeostaticComponents;
import homeostatic.common.wetness.WetnessInfo;
import homeostatic.platform.Services;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GameType;

public class WetnessHelper {
    public static void updateWetnessInfo(ServerPlayer sp, float moistureLevel, boolean increase) {
        if (sp.gameMode.getGameModeForPlayer() != GameType.SURVIVAL || sp.hasEffect(MobEffects.WATER_BREATHING)) {
            return;
        }
        Services.PLATFORM.getWetnessCapability((Player)sp).ifPresent(data -> {
            WetnessInfo wetnessInfo = new WetnessInfo(data.getWetnessLevel(), data.getMoistureLevel());
            AtomicInteger waterproofing = new AtomicInteger();
            for (EquipmentSlot slot : EquipmentSlotGroup.ARMOR) {
                CompoundTag tags;
                ItemStack armor = sp.getItemBySlot(slot);
                if (armor.isEmpty() || !(tags = ((CustomData)armor.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag()).contains("waterproof") && !armor.is(TagManager.Items.WATERPROOF_ARMOR)) continue;
                waterproofing.addAndGet(5);
            }
            if (increase) {
                wetnessInfo.increaseMoisture(moistureLevel, waterproofing.get());
            } else {
                wetnessInfo.decreaseMoisture(moistureLevel);
            }
            data.setWetnessData(wetnessInfo);
            Services.PLATFORM.syncWetnessData(sp, wetnessInfo);
        });
    }

    public static int getWetness(ServerPlayer sp) {
        AtomicInteger wetness = new AtomicInteger();
        Services.PLATFORM.getWetnessCapability((Player)sp).ifPresent(data -> wetness.set(data.getWetnessLevel()));
        return wetness.get();
    }
}

