/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.wetness;

public class WetnessInfo {
    public static final int MAX_WETNESS_LEVEL = 20;
    public static final float MAX_MOISTURE_LEVEL = 20.0f;
    public static final float MIN_MOISTURE_LEVEL = -20.0f;
    private int wetnessLevel;
    private float moistureLevel;

    public WetnessInfo(int wetnessLevel, float moistureLevel) {
        this.wetnessLevel = wetnessLevel;
        this.moistureLevel = moistureLevel;
    }

    public int getWetnessLevel() {
        return this.wetnessLevel;
    }

    public void setWetnessLevel(int wetnessLevel) {
        this.wetnessLevel = Math.max(wetnessLevel, 0);
    }

    public float getMoistureLevel() {
        return this.moistureLevel;
    }

    public void increaseMoisture(float moistureLevel, int waterproofing) {
        float moistureReduction = moistureLevel * ((float)waterproofing / 20.0f);
        moistureLevel -= moistureReduction;
        if (this.moistureLevel > 4.0f) {
            this.moistureLevel -= 4.0f;
            this.setWetnessLevel(Math.min(this.wetnessLevel + 1, 20 - waterproofing));
        }
        if (moistureLevel > 0.0f) {
            this.addMoisture(moistureLevel);
        }
    }

    public void decreaseMoisture(float moistureLevel) {
        if (this.moistureLevel < -4.0f) {
            this.moistureLevel += 4.0f;
            this.setWetnessLevel(Math.max(this.wetnessLevel - 1, 0));
        }
        if (moistureLevel > 0.0f) {
            this.removeMoisture(moistureLevel);
        }
    }

    public void addMoisture(float amount) {
        this.moistureLevel = Math.min(this.moistureLevel + amount, 20.0f);
    }

    public void removeMoisture(float amount) {
        this.moistureLevel = this.wetnessLevel > 0 ? Math.max(this.moistureLevel - amount, -20.0f) : 0.0f;
    }
}

