/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.integrations.jei;

import homeostatic.Homeostatic;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.recipe.ArmorEnhancement;
import homeostatic.common.recipe.CampfirePurifiedLeatherFlask;
import homeostatic.common.recipe.CampfirePurifiedWaterBottle;
import homeostatic.common.recipe.HelmetThermometer;
import homeostatic.common.recipe.SmeltingPurifiedLeatherFlask;
import homeostatic.common.recipe.SmeltingPurifiedWaterBottle;
import homeostatic.common.recipe.SmokingPurifiedLeatherFlask;
import homeostatic.common.recipe.SmokingPurifiedWaterBottle;
import homeostatic.config.ConfigHandler;
import homeostatic.integrations.ArmorEnhancementRecipeMaker;
import homeostatic.integrations.CampfireRecipeMaker;
import homeostatic.integrations.HelmetThermometerRecipeMaker;
import homeostatic.integrations.SmeltingRecipeMaker;
import homeostatic.integrations.SmokerRecipeMaker;
import homeostatic.integrations.WaterFilterRecipeMaker;
import homeostatic.integrations.jei.Recipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.common.Internal;
import net.minecraft.class_10289;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3955;
import net.minecraft.class_8786;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public class_2960 getPluginUid() {
        return Homeostatic.prefix("jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        class_10289 clientSyncedRecipes = Internal.getClientSyncedRecipes();
        if (clientSyncedRecipes.method_64695().isEmpty()) {
            Homeostatic.LOGGER.error("JEI Recipe Registration failed: No synced recipes");
            return;
        }
        Recipes recipes = new Recipes(clientSyncedRecipes);
        List<class_8786<class_3955>> craftingRecipes = recipes.getCraftingRecipes();
        List<class_8786<class_3955>> armorEnhancementRecipes = JEIPlugin.addArmorCraftingRecipes(craftingRecipes);
        List<class_8786<class_3920>> allCampfireRecipes = recipes.getCampfireCookingRecipes();
        List<class_8786<class_3920>> purifiedWaterCampfireRecipes = JEIPlugin.addCampfireRecipes(allCampfireRecipes);
        List<class_8786<class_3862>> allSmokingRecipes = recipes.getSmokingRecipes();
        List<class_8786<class_3862>> purifiedWaterSmokingRecipes = JEIPlugin.addSmokingRecipes(allSmokingRecipes);
        List<class_8786<class_3861>> allSmeltingRecipes = recipes.getSmeltingRecipes();
        List<class_8786<class_3861>> purifiedWaterSmeltingRecipes = JEIPlugin.addSmeltingRecipes(allSmeltingRecipes);
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, armorEnhancementRecipes);
        ArrayList waterFilterRecipes = new ArrayList();
        WaterFilterRecipeMaker.getFilterCraftingRecipes("jei").forEach(pair -> waterFilterRecipes.add((class_8786)pair.getSecond()));
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, waterFilterRecipes);
        registration.addRecipes((IRecipeType)RecipeTypes.CAMPFIRE_COOKING, purifiedWaterCampfireRecipes);
        registration.addRecipes((IRecipeType)RecipeTypes.SMOKING, purifiedWaterSmokingRecipes);
        registration.addRecipes((IRecipeType)RecipeTypes.SMELTING, purifiedWaterSmeltingRecipes);
        if (!ConfigHandler.Common.requireThermometer()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new class_1799((class_1935)HomeostaticItems.THERMOMETER)));
        }
    }

    private static List<class_8786<class_3955>> addArmorCraftingRecipes(List<class_8786<class_3955>> craftingRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        ArrayList recipes = new ArrayList();
        ArrayList helmetThermometerRecipes = new ArrayList();
        ArmorEnhancementRecipeMaker.createRecipes("jei").forEach(pair -> recipes.add((class_8786)pair.getSecond()));
        replacers.put(ArmorEnhancement.class, () -> recipes);
        if (ConfigHandler.Common.requireThermometer()) {
            HelmetThermometerRecipeMaker.createRecipes("jei").forEach(pair -> helmetThermometerRecipes.add((class_8786)pair.getSecond()));
            replacers.put(HelmetThermometer.class, () -> helmetThermometerRecipes);
        }
        return craftingRecipes.stream().map(class_8786::comp_1933).map(class_3955::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                return ((List)supplier.get()).stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new class_8786[0]);
            }
        }).toList();
    }

    private static List<class_8786<class_3920>> addCampfireRecipes(List<class_8786<class_3920>> campfireRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(CampfirePurifiedLeatherFlask.class, () -> CampfireRecipeMaker.createFlaskRecipes("jei"));
        replacers.put(CampfirePurifiedWaterBottle.class, () -> CampfireRecipeMaker.createWaterBottleRecipes("jei"));
        return campfireRecipes.stream().map(class_8786::comp_1933).map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                return ((List)supplier.get()).stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new class_8786[0]);
            }
        }).toList();
    }

    private static List<class_8786<class_3862>> addSmokingRecipes(List<class_8786<class_3862>> smokingRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(SmokingPurifiedLeatherFlask.class, () -> SmokerRecipeMaker.createFlaskRecipes("jei"));
        replacers.put(SmokingPurifiedWaterBottle.class, () -> SmokerRecipeMaker.createWaterBottleRecipes("jei"));
        return smokingRecipes.stream().map(class_8786::comp_1933).map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                return ((List)supplier.get()).stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new class_8786[0]);
            }
        }).toList();
    }

    private static List<class_8786<class_3861>> addSmeltingRecipes(List<class_8786<class_3861>> smeltingRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(SmeltingPurifiedLeatherFlask.class, () -> SmeltingRecipeMaker.createFlaskRecipes("jei"));
        replacers.put(SmeltingPurifiedWaterBottle.class, () -> SmeltingRecipeMaker.createWaterBottleRecipes("jei"));
        return smeltingRecipes.stream().map(class_8786::comp_1933).map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                return ((List)supplier.get()).stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new class_8786[0]);
            }
        }).toList();
    }
}

