/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.integrations.rei;

import com.mojang.datafixers.util.Pair;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.config.ConfigHandler;
import homeostatic.integrations.ArmorEnhancementRecipeMaker;
import homeostatic.integrations.CampfireRecipeMaker;
import homeostatic.integrations.HelmetThermometerRecipeMaker;
import homeostatic.integrations.SmeltingRecipeMaker;
import homeostatic.integrations.SmokerRecipeMaker;
import homeostatic.integrations.WaterFilterRecipeMaker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.DefaultCampfireDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmeltingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmokingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_3955;
import net.minecraft.class_8786;

public class REIPlugin
implements REIClientPlugin {
    public void registerDisplays(DisplayRegistry helper) {
        List<Pair<class_1799, class_8786<class_3955>>> recipes = ArmorEnhancementRecipeMaker.createRecipes("rei");
        List campfireRecipes = Stream.concat(CampfireRecipeMaker.createFlaskRecipes("rei").stream(), CampfireRecipeMaker.createWaterBottleRecipes("rei").stream()).toList();
        List smokingRecipes = Stream.concat(SmokerRecipeMaker.createFlaskRecipes("rei").stream(), SmokerRecipeMaker.createWaterBottleRecipes("rei").stream()).toList();
        List smeltingRecipes = Stream.concat(SmeltingRecipeMaker.createFlaskRecipes("rei").stream(), SmeltingRecipeMaker.createWaterBottleRecipes("rei").stream()).toList();
        if (ConfigHandler.Common.requireThermometer()) {
            recipes.addAll(HelmetThermometerRecipeMaker.createRecipes("rei"));
        }
        recipes.addAll(WaterFilterRecipeMaker.getFilterCraftingRecipes("rei"));
        recipes.forEach(recipePair -> {
            ArrayList input = new ArrayList();
            ((class_3955)((class_8786)recipePair.getSecond()).comp_1933()).method_61671().method_64675().forEach(ingredient -> input.add(EntryIngredients.ofIngredient((class_1856)ingredient)));
            helper.add((Display)new DefaultCustomDisplay(input, Collections.singletonList(EntryIngredients.of((class_1799)((class_1799)recipePair.getFirst()))), Optional.of(((class_8786)recipePair.getSecond()).comp_1932().method_29177())));
        });
        campfireRecipes.forEach(recipe -> helper.add((Display)new DefaultCampfireDisplay(recipe)));
        smokingRecipes.forEach(recipe -> helper.add((Display)new DefaultSmokingDisplay(recipe)));
        smeltingRecipes.forEach(recipe -> helper.add((Display)new DefaultSmeltingDisplay(recipe)));
    }

    public void registerEntries(EntryRegistry registry) {
        registry.removeEntryIf(this::shouldHideEntry);
    }

    private boolean shouldHideEntry(EntryStack<?> entryStack) {
        if (entryStack.getType() != VanillaEntryTypes.ITEM) {
            return false;
        }
        class_1799 stack = (class_1799)entryStack.castValue();
        if (!ConfigHandler.Common.requireThermometer()) {
            return stack.method_7909() == HomeostaticItems.THERMOMETER;
        }
        return false;
    }
}

