/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import homeostatic.common.temperature.TemperatureRange;
import homeostatic.config.ConfigHandler;
import java.awt.Color;
import net.minecraft.class_3545;
import technology.roughness.whitenoise.util.ColorHelper;

public class ColorHelper {
    public static final Color neutral = ColorHelper.Colors.NEUTRAL.toColor();

    public static int getTemperatureColor(class_3545<TemperatureRange, Integer> rangeStep) {
        Color hot = ConfigHandler.Client.temperatureColorHot();
        Color cold = ConfigHandler.Client.temperatureColorCold();
        return ColorHelper.getTemperatureColorFromRange(rangeStep, hot, cold, false);
    }

    public static int getGlobeTemperatureColor(class_3545<TemperatureRange, Integer> rangeStep) {
        Color color = ColorHelper.Colors.WHITE.toColor();
        return ColorHelper.getTemperatureColorFromRange(rangeStep, color, color, true);
    }

    public static int getTemperatureColorFromRange(class_3545<TemperatureRange, Integer> rangeStep, Color hot, Color cold, boolean invert) {
        TemperatureRange range = (TemperatureRange)((Object)rangeStep.method_15442());
        Color stepColor = range == TemperatureRange.HOT ? hot : cold;
        if (invert) {
            return ColorHelper.getRangeColor(stepColor, neutral, 18, (Integer)rangeStep.method_15441() + 1);
        }
        return ColorHelper.getRangeColor(neutral, stepColor, 18, (Integer)rangeStep.method_15441() + 1);
    }

    public static int getLocalTemperatureColor(class_3545<TemperatureRange, Integer> rangeStep) {
        TemperatureRange range = (TemperatureRange)((Object)rangeStep.method_15442());
        Color tempColor = range == TemperatureRange.COLD ? ConfigHandler.Client.temperatureColorCold() : ConfigHandler.Client.temperatureColorHot();
        return ColorHelper.getRangeColor(neutral, tempColor, 18, (Integer)rangeStep.method_15441() + 1);
    }

    public static Color decode(String color) {
        return Color.decode(color);
    }

    private static int getRangeColor(Color from, Color to, int steps, int step) {
        int diffRed = to.getRed() - from.getRed();
        int diffGreen = to.getGreen() - from.getGreen();
        int diffBlue = to.getBlue() - from.getBlue();
        return new Color(from.getRed() + diffRed * step / steps, from.getGreen() + diffGreen * step / steps, from.getBlue() + diffBlue * step / steps).getRGB();
    }
}

