/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import homeostatic.Homeostatic;
import homeostatic.common.Hydration;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.fluid.DrinkingFluid;
import homeostatic.common.fluid.DrinkingFluidManager;
import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.DrinkableItem;
import homeostatic.common.item.DrinkableItemManager;
import homeostatic.common.water.WaterInfo;
import homeostatic.config.ConfigHandler;
import homeostatic.platform.Services;
import homeostatic.util.Alignment;
import homeostatic.util.RegistryHelper;
import java.util.Optional;
import net.minecraft.class_10799;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class WaterHelper {
    public static void updateWaterInfo(class_3222 sp, float sweatLevel) {
        if (sp.field_13974.method_14257() != class_1934.field_9215) {
            return;
        }
        Services.PLATFORM.getWaterCapabilty((class_1657)sp).ifPresent(data -> {
            WaterInfo waterInfo = new WaterInfo(data.getWaterLevel(), data.getWaterSaturationLevel(), data.getWaterExhaustionLevel());
            waterInfo.update(sweatLevel);
            data.setWaterData(waterInfo);
            Services.PLATFORM.syncWaterData(sp, waterInfo);
        });
    }

    public static void drink(class_3222 sp, class_1799 stack, boolean update) {
        WaterHelper.drink(sp, WaterHelper.getItemHydration(stack), update);
    }

    public static void drink(class_3222 sp, class_1799 stack, @Nullable class_3611 fluid) {
        WaterHelper.drink(sp, stack, fluid, true);
    }

    public static void drink(class_3222 sp, class_1799 stack, @Nullable class_3611 fluid, boolean update) {
        WaterHelper.drink(sp, WaterHelper.getItemHydration(stack, fluid), update);
    }

    public static void drink(class_3222 sp, @Nullable Hydration hydration, boolean update) {
        if (hydration != null) {
            Services.PLATFORM.getWaterCapabilty((class_1657)sp).ifPresent(data -> {
                boolean isDirty = hydration.duration() > 0;
                float chance = hydration.chance();
                data.increaseWaterLevel(hydration.amount());
                data.increaseSaturationLevel(hydration.saturation());
                if (!sp.method_6059(class_7923.field_41174.method_47983((Object)HomeostaticEffects.THIRST))) {
                    chance *= 0.5f;
                }
                if (isDirty && Homeostatic.RANDOM.nextFloat() < chance) {
                    sp.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)HomeostaticEffects.THIRST), hydration.duration(), hydration.potency(), false, false, false));
                }
                if (update) {
                    Services.PLATFORM.syncWaterData(sp, new WaterInfo(data.getWaterLevel(), data.getWaterSaturationLevel(), data.getWaterExhaustionLevel()));
                }
            });
        }
    }

    public static Hydration getItemHydration(@Nullable class_1799 stack, @Nullable class_3611 fluid) {
        DrinkableItem drinkableItem = stack != null ? DrinkableItemManager.get(stack) : null;
        DrinkingFluid drinkingFluid = fluid != null ? DrinkingFluidManager.get(fluid) : null;
        Hydration hydration = null;
        if (drinkingFluid != null) {
            hydration = DrinkingFluid.getHydration(drinkingFluid);
        } else if (drinkableItem != null) {
            hydration = DrinkableItem.getHydration(drinkableItem);
        }
        return hydration;
    }

    public static Hydration getItemHydration(class_1799 stack) {
        Object fluid = null;
        if (stack.method_7909() instanceof class_1812) {
            class_1844 potion = (class_1844)stack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
            stack = new class_1799((class_1935)class_1802.field_8162);
            fluid = !potion.method_57401(class_1847.field_8991) ? HomeostaticFluids.PURIFIED_WATER : class_3612.field_15910;
        } else {
            Optional<FluidInfo> fluidInfoOptional = Services.PLATFORM.getFluidInfo(stack);
            if (fluidInfoOptional.isPresent()) {
                fluid = fluidInfoOptional.get().fluid();
            }
        }
        return WaterHelper.getItemHydration(stack, fluid);
    }

    public static Hydration getFluidHydration(class_3611 fluid) {
        return WaterHelper.getItemHydration(null, fluid);
    }

    public static void drinkWater(class_3222 sp) {
        WaterHelper.drinkDirtyWaterItem(sp, false);
    }

    public static void drinkDirtyWaterItem(class_3222 sp, boolean update) {
        class_1799 air = new class_1799((class_1935)class_1802.field_8162);
        WaterHelper.drink(sp, air, (class_3611)class_3612.field_15910, update);
    }

    public static void drawWaterBar(class_2960 sprite, int scaledWidth, int scaledHeight, class_1293 effectInstance, class_329 gui, class_332 guiGraphics, float waterSaturationLevel, int waterLevel, int tickCount) {
        int offsetY;
        int offsetX;
        int pV = 0;
        int pU = 0;
        int pUOffset = 0;
        if (ConfigHandler.Client.forceWaterBarPosition()) {
            offsetX = Alignment.getX(ConfigHandler.Client.globePosition(), scaledWidth, 9, ConfigHandler.Client.waterBarOffsetX());
            offsetY = Alignment.getY(ConfigHandler.Client.waterBarPosition(), scaledHeight, ConfigHandler.Client.waterBarOffsetY());
        } else {
            offsetX = scaledWidth / 2 + 91;
            offsetY = scaledHeight;
        }
        int pY = offsetY;
        if (effectInstance != null) {
            pU += 18;
            pUOffset += 9;
        }
        for (int i = 0; i < 10; ++i) {
            int pX = offsetX - i * 8 - 9;
            guiGraphics.method_25290(class_10799.field_56883, sprite, pX, pY, (float)(pUOffset + 36), (float)pV, 9, 9, 256, 256);
            if (waterSaturationLevel <= 0.0f && tickCount % (waterLevel * 3 + 1) == 0) {
                pY = offsetY + (Homeostatic.RANDOM.nextInt(3) - 1);
            }
            if (i * 2 + 1 < waterLevel) {
                guiGraphics.method_25290(class_10799.field_56883, sprite, pX, pY, (float)pU, (float)pV, 9, 9, 256, 256);
            }
            if (i * 2 + 1 == waterLevel) {
                guiGraphics.method_25290(class_10799.field_56883, sprite, pX, pY, (float)(pU + 9), (float)pV, 9, 9, 256, 256);
            }
            if ((float)(i * 2 + 1) < waterSaturationLevel) {
                guiGraphics.method_25290(class_10799.field_56883, sprite, pX, pY - 1, (float)pU, (float)(pV + 9), 9, 9, 256, 256);
                guiGraphics.method_25290(class_10799.field_56883, sprite, pX, pY + 1, (float)(pU + 9), (float)(pV + 9), 9, 9, 256, 256);
            }
            if ((float)(i * 2 + 1) != waterSaturationLevel) continue;
            guiGraphics.method_25290(class_10799.field_56883, sprite, pX, pY, (float)pU, (float)(pV + 9), 9, 9, 256, 256);
        }
    }

    public static class_1799 getFilledItem(class_1799 stack, class_3611 fluid, int amount) {
        return Services.PLATFORM.fillFluid(stack, fluid, amount);
    }

    public static class_1799 getFilledItem(class_1799 stack, class_2960 key, int amount) {
        Optional fluid = RegistryHelper.getRegistry(class_7924.field_41270).method_10223(key);
        if (fluid.isEmpty()) {
            Homeostatic.LOGGER.warn("Fluid with key {} not found in registry", (Object)key);
            return stack;
        }
        return WaterHelper.getFilledItem(stack, (class_3611)((class_6880.class_6883)fluid.get()).comp_349(), amount);
    }
}

