/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.block;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.block.BlockRadiation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BlockRadiationManager
extends SimpleJsonResourceReloadListener<JsonElement> {
    private static final Map<Block, BlockRadiation> RADIATION_BLOCKS = new HashMap<Block, BlockRadiation>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockRadiation.class, (Object)new BlockRadiation.Serializer()).create();

    public BlockRadiationManager() {
        super(ExtraCodecs.JSON, FileToIdConverter.json((String)"environment/block_radiation"));
    }

    public static JsonElement parseBlockRadiation(BlockRadiation blockRadiation) {
        return GSON.toJsonTree((Object)blockRadiation);
    }

    public static BlockRadiation getBlockRadiation(Block block) {
        return RADIATION_BLOCKS.get(block);
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        RADIATION_BLOCKS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            try {
                BlockRadiation blockRadiation = (BlockRadiation)GSON.fromJson(entry.getValue(), BlockRadiation.class);
                Optional block = BuiltInRegistries.BLOCK.get(blockRadiation.loc());
                block.ifPresent(blockReference -> RADIATION_BLOCKS.put((Block)blockReference.value(), blockRadiation));
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse block radiation {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} radiation blocks", (Object)RADIATION_BLOCKS.size());
    }
}

