/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.recipe;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import homeostatic.common.TagManager;
import homeostatic.common.component.HomeostaticComponents;
import homeostatic.common.recipe.HomeostaticRecipes;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ArmorEnhancement
extends CustomRecipe {
    public ArmorEnhancement(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput craftingInput, @NotNull Level level) {
        Pair<ItemStack, TagKey<Item>> check = this.checkContainer(craftingInput);
        ItemStack armor = (ItemStack)check.getFirst();
        TagKey tagKey = (TagKey)check.getSecond();
        return tagKey != null && armor != null;
    }

    public ItemStack assemble(@NotNull CraftingInput craftingInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        Pair<ItemStack, TagKey<Item>> check = this.checkContainer(craftingInput);
        ItemStack armorCopy = ((ItemStack)check.getFirst()).copy();
        TagKey tagKey = (TagKey)check.getSecond();
        CompoundTag tags = ((CustomData)armorCopy.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
        boolean save = false;
        if (tagKey == TagManager.Items.INSULATION) {
            if (!tags.contains("insulation")) {
                save = true;
                tags.putBoolean("insulation", true);
            }
        } else if (tagKey == TagManager.Items.WATERPROOF) {
            if (!tags.contains("waterproof")) {
                save = true;
                tags.putBoolean("waterproof", true);
            }
        } else if (tagKey == TagManager.Items.RADIATION_PROTECTION && !tags.contains("radiation_protection")) {
            save = true;
            tags.putBoolean("radiation_protection", true);
        }
        if (save) {
            armorCopy.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)tags));
        }
        return armorCopy;
    }

    @NotNull
    public RecipeSerializer<ArmorEnhancement> getSerializer() {
        return HomeostaticRecipes.ARMOR_ENHANCEMENT_SERIALIZER;
    }

    public Pair<ItemStack, TagKey<Item>> checkContainer(CraftingInput craftingInput) {
        ArrayList ingredients = Lists.newArrayList();
        TagKey<Item> tagKey = null;
        ItemStack armor = null;
        boolean hasInsulation = false;
        boolean hasWaterproof = false;
        boolean hasRadiation = false;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack ingredient = craftingInput.getItem(i);
            if (ingredient.is(TagManager.Items.INSULATION) && !hasWaterproof && !hasRadiation) {
                hasInsulation = true;
                tagKey = TagManager.Items.INSULATION;
                ingredients.add(ingredient);
                continue;
            }
            if (ingredient.is(TagManager.Items.WATERPROOF) && !hasInsulation && !hasRadiation) {
                hasWaterproof = true;
                tagKey = TagManager.Items.WATERPROOF;
                ingredients.add(ingredient);
                continue;
            }
            if (ingredient.is(TagManager.Items.RADIATION_PROTECTION) && !hasWaterproof && !hasInsulation) {
                hasRadiation = true;
                tagKey = TagManager.Items.RADIATION_PROTECTION;
                ingredients.add(ingredient);
                continue;
            }
            if (ingredient.get(DataComponents.EQUIPPABLE) == null) continue;
            armor = ingredient;
        }
        if (ingredients.size() != 3) {
            tagKey = null;
        }
        return Pair.of(armor, tagKey);
    }
}

