/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data.recipe;

import homeostatic.Homeostatic;
import homeostatic.common.recipe.ArmorEnhancement;
import homeostatic.common.recipe.HelmetThermometer;
import homeostatic.common.recipe.HomeostaticRecipes;
import homeostatic.common.recipe.PurifiedLeatherFlask;
import homeostatic.common.recipe.RemoveArmorEnhancement;
import homeostatic.data.recipe.RecipeProviderBase;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;

public class CommonRecipeProvider
extends RecipeProvider {
    RecipeOutput recipeOutput;
    HolderLookup.Provider registries;

    public CommonRecipeProvider(HolderLookup.Provider registries, RecipeOutput recipeOutput) {
        super(registries, recipeOutput);
        this.recipeOutput = recipeOutput;
        this.registries = registries;
    }

    public void buildRecipes() {
        HolderLookup.RegistryLookup itemRegistry = this.registries.lookupOrThrow(Registries.ITEM);
        RecipeProviderBase.specialRecipe(this.recipeOutput, (CustomRecipe.Serializer)HomeostaticRecipes.ARMOR_ENHANCEMENT_SERIALIZER, ArmorEnhancement::new);
        RecipeProviderBase.specialRecipe(this.recipeOutput, (CustomRecipe.Serializer)HomeostaticRecipes.PURIFIED_LEATHER_FLASK_SERIALIZER, PurifiedLeatherFlask::new);
        RecipeProviderBase.specialRecipe(this.recipeOutput, (CustomRecipe.Serializer)HomeostaticRecipes.HELMET_THERMOMETER_SERIALIZER, HelmetThermometer::new);
        RecipeProviderBase.specialRecipe(this.recipeOutput, (CustomRecipe.Serializer)HomeostaticRecipes.REMOVE_ARMOR_ENHANCEMENT_SERIALIZER, RemoveArmorEnhancement::new);
        RecipeProviderBase.cleanWaterFlaskSmelting((HolderLookup.RegistryLookup<Item>)itemRegistry).save(this.recipeOutput, this.getKey("furnace_purified_leather_flask"));
        RecipeProviderBase.cleanWaterFlaskCampfire((HolderLookup.RegistryLookup<Item>)itemRegistry).save(this.recipeOutput, this.getKey("campfire_purified_leather_flask"));
        RecipeProviderBase.cleanWaterFlaskSmoking((HolderLookup.RegistryLookup<Item>)itemRegistry).save(this.recipeOutput, this.getKey("smoking_purified_leather_flask"));
        RecipeProviderBase.leatherFlask((HolderLookup.RegistryLookup<Item>)itemRegistry).save(this.recipeOutput);
        RecipeProviderBase.waterFilter((HolderLookup.RegistryLookup<Item>)itemRegistry).save(this.recipeOutput);
        RecipeProviderBase.thermometer((HolderLookup.RegistryLookup<Item>)itemRegistry).save(this.recipeOutput);
        RecipeProviderBase.cleanWaterBottleSmelting((HolderLookup.RegistryLookup<Item>)itemRegistry).save(this.recipeOutput, this.getKey("furnace_purified_water_bottle"));
        RecipeProviderBase.cleanWaterBottleCampfire((HolderLookup.RegistryLookup<Item>)itemRegistry).save(this.recipeOutput, this.getKey("campfire_purified_water_bottle"));
        RecipeProviderBase.cleanWaterBottleSmoking((HolderLookup.RegistryLookup<Item>)itemRegistry).save(this.recipeOutput, this.getKey("smoking_purified_water_bottle"));
        RecipeProviderBase.book((HolderLookup.RegistryLookup<Item>)itemRegistry).save(this.recipeOutput, "book_from_dirt");
    }

    private ResourceKey<Recipe<?>> getKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Homeostatic.prefix(id));
    }
}

