/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data.recipe;

import homeostatic.Homeostatic;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.data.AdvancedCookingRecipeBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public abstract class RecipeProviderBase {
    public static final ItemStack waterBottle = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);

    protected static void specialRecipe(RecipeOutput exporter, CustomRecipe.Serializer<?> serializer, Function<CraftingBookCategory, Recipe<?>> recipeFunction) {
        ResourceLocation name = BuiltInRegistries.RECIPE_SERIALIZER.getKey(serializer);
        SpecialRecipeBuilder.special(recipeFunction).save(exporter, Homeostatic.prefix("dynamic/" + Objects.requireNonNull(name).getPath()).toString());
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> has(HolderLookup.RegistryLookup<Item> itemRegistry, TagKey<Item> pTag) {
        return RecipeProviderBase.inventoryTrigger(ItemPredicate.Builder.item().of(itemRegistry, pTag).build());
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> has(HolderLookup.RegistryLookup<Item> itemRegistry, ItemLike pItemLike) {
        return RecipeProviderBase.inventoryTrigger(ItemPredicate.Builder.item().of(itemRegistry, new ItemLike[]{pItemLike}).build());
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate ... predicates) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(predicates)));
    }

    public static ShapedRecipeBuilder leatherFlask(HolderLookup.RegistryLookup<Item> itemRegistry) {
        return ShapedRecipeBuilder.shaped(itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)HomeostaticItems.LEATHER_FLASK).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('P'), ItemTags.PLANKS).pattern("SPS").pattern("L L").pattern("LLL").unlockedBy("has_leather", RecipeProviderBase.has(itemRegistry, (ItemLike)Items.LEATHER));
    }

    public static ShapedRecipeBuilder waterFilter(HolderLookup.RegistryLookup<Item> itemRegistry) {
        return ShapedRecipeBuilder.shaped(itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)HomeostaticItems.WATER_FILTER).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('C'), (ItemLike)Items.CHARCOAL).pattern("P").pattern("C").pattern("P").unlockedBy("has_charcoal", RecipeProviderBase.has(itemRegistry, (ItemLike)Items.CHARCOAL));
    }

    public static ShapedRecipeBuilder thermometer(HolderLookup.RegistryLookup<Item> itemRegistry) {
        return ShapedRecipeBuilder.shaped(itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)HomeostaticItems.THERMOMETER).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('D'), (ItemLike)Items.REDSTONE).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).pattern("N").pattern("D").pattern("I").unlockedBy("has_redstone", RecipeProviderBase.has(itemRegistry, (ItemLike)Items.REDSTONE));
    }

    public static ShapelessRecipeBuilder book(HolderLookup.RegistryLookup<Item> itemRegistry) {
        return ShapelessRecipeBuilder.shapeless(itemRegistry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)HomeostaticItems.BOOK).requires((ItemLike)Items.DIRT).group("books").unlockedBy("has_dirt", RecipeProviderBase.has(itemRegistry, (ItemLike)Items.DIRT));
    }

    public static RecipeBuilder cleanWaterFlaskSmelting(HolderLookup.RegistryLookup<Item> itemRegistry) {
        return AdvancedCookingRecipeBuilder.leatherFlaskSmelting(Ingredient.of((ItemLike)HomeostaticItems.LEATHER_FLASK), RecipeCategory.MISC, (ItemLike)HomeostaticItems.LEATHER_FLASK, 0.15f, 150).unlockedBy("has_leather_flask", RecipeProviderBase.has(itemRegistry, (ItemLike)HomeostaticItems.LEATHER_FLASK));
    }

    public static RecipeBuilder cleanWaterFlaskCampfire(HolderLookup.RegistryLookup<Item> itemRegistry) {
        return AdvancedCookingRecipeBuilder.campfireLeatherFlaskCooking(Ingredient.of((ItemLike)HomeostaticItems.LEATHER_FLASK), RecipeCategory.MISC, (ItemLike)HomeostaticItems.LEATHER_FLASK, 0.15f, 200).unlockedBy("has_leather_flask", RecipeProviderBase.has(itemRegistry, (ItemLike)HomeostaticItems.LEATHER_FLASK));
    }

    public static RecipeBuilder cleanWaterFlaskSmoking(HolderLookup.RegistryLookup<Item> itemRegistry) {
        return AdvancedCookingRecipeBuilder.leatherFlaskSmoking(Ingredient.of((ItemLike)HomeostaticItems.LEATHER_FLASK), RecipeCategory.MISC, (ItemLike)HomeostaticItems.LEATHER_FLASK, 0.15f, 100).unlockedBy("has_leather_flask", RecipeProviderBase.has(itemRegistry, (ItemLike)HomeostaticItems.LEATHER_FLASK));
    }

    public static RecipeBuilder cleanWaterBottleSmelting(HolderLookup.RegistryLookup<Item> itemRegistry) {
        return AdvancedCookingRecipeBuilder.waterBottleSmelting(Ingredient.of((ItemLike)waterBottle.getItem()), RecipeCategory.MISC, (ItemLike)HomeostaticItems.PURIFIED_WATER_BOTTLE, 0.05f, 75).unlockedBy("has_glass_bottle", RecipeProviderBase.has(itemRegistry, (ItemLike)Items.GLASS_BOTTLE));
    }

    public static RecipeBuilder cleanWaterBottleCampfire(HolderLookup.RegistryLookup<Item> itemRegistry) {
        return AdvancedCookingRecipeBuilder.campfireWaterBottleCooking(Ingredient.of((ItemLike)waterBottle.getItem()), RecipeCategory.MISC, (ItemLike)HomeostaticItems.PURIFIED_WATER_BOTTLE, 0.05f, 100).unlockedBy("has_glass_bottle", RecipeProviderBase.has(itemRegistry, (ItemLike)Items.GLASS_BOTTLE));
    }

    public static RecipeBuilder cleanWaterBottleSmoking(HolderLookup.RegistryLookup<Item> itemRegistry) {
        return AdvancedCookingRecipeBuilder.waterBottleSmoking(Ingredient.of((ItemLike)waterBottle.getItem()), RecipeCategory.MISC, (ItemLike)HomeostaticItems.PURIFIED_WATER_BOTTLE, 0.05f, 50).unlockedBy("has_glass_bottle", RecipeProviderBase.has(itemRegistry, (ItemLike)Items.GLASS_BOTTLE));
    }
}

