/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.integrations;

import com.mojang.datafixers.util.Pair;
import homeostatic.Homeostatic;
import homeostatic.common.TagManager;
import homeostatic.common.component.HomeostaticComponents;
import homeostatic.util.IngredientHelper;
import homeostatic.util.RegistryHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public final class ArmorEnhancementRecipeMaker {
    public static List<Pair<ItemStack, RecipeHolder<CraftingRecipe>>> createRecipes(String plugin) {
        String group = plugin + ".armor.enhancement";
        ArrayList<Pair<ItemStack, RecipeHolder<CraftingRecipe>>> recipes = new ArrayList<Pair<ItemStack, RecipeHolder<CraftingRecipe>>>();
        Ingredient wool = IngredientHelper.fromTag(TagManager.Items.INSULATION);
        Ingredient waterproof = IngredientHelper.fromTag(TagManager.Items.WATERPROOF);
        Ingredient radiation = IngredientHelper.fromTag(TagManager.Items.RADIATION_PROTECTION);
        RegistryHelper.getRegistry(Registries.ITEM).stream().filter(item -> item.components().get(DataComponents.EQUIPPABLE) != null).forEach(armorItem -> {
            Ingredient baseArmorIngredient = Ingredient.of((ItemLike)armorItem.asItem());
            ItemStack woolArmorStack = new ItemStack((ItemLike)armorItem);
            ItemStack waterproofArmorStack = new ItemStack((ItemLike)armorItem);
            ItemStack radiationArmorStack = new ItemStack((ItemLike)armorItem);
            CompoundTag woolArmorStackTag = ((CustomData)woolArmorStack.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
            CompoundTag waterproofArmorStackTag = ((CustomData)waterproofArmorStack.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
            CompoundTag radiationArmorStackTag = ((CustomData)radiationArmorStack.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
            NonNullList insulatedInputs = NonNullList.of(null, (Object[])new Ingredient[]{baseArmorIngredient, wool, wool, wool});
            NonNullList waterproofInputs = NonNullList.of(null, (Object[])new Ingredient[]{baseArmorIngredient, waterproof, waterproof, waterproof});
            NonNullList radiationInputs = NonNullList.of(null, (Object[])new Ingredient[]{baseArmorIngredient, radiation, radiation, radiation});
            woolArmorStackTag.putBoolean("insulation", true);
            woolArmorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)woolArmorStackTag));
            recipes.add(Pair.of((Object)woolArmorStack, (Object)new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Homeostatic.prefix(group + ".insulated")), (Recipe)new ShapelessRecipe(group, CraftingBookCategory.EQUIPMENT, woolArmorStack, (List)insulatedInputs))));
            waterproofArmorStackTag.putBoolean("waterproof", true);
            waterproofArmorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)waterproofArmorStackTag));
            recipes.add(Pair.of((Object)waterproofArmorStack, (Object)new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Homeostatic.prefix(group + ".waterproof")), (Recipe)new ShapelessRecipe(group, CraftingBookCategory.EQUIPMENT, waterproofArmorStack, (List)waterproofInputs))));
            radiationArmorStackTag.putBoolean("radiation_protection", true);
            radiationArmorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)radiationArmorStackTag));
            recipes.add(Pair.of((Object)radiationArmorStack, (Object)new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Homeostatic.prefix(group + ".radiation_resistance")), (Recipe)new ShapelessRecipe(group, CraftingBookCategory.EQUIPMENT, radiationArmorStack, (List)radiationInputs))));
        });
        return recipes;
    }
}

