/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.Homeostatic;
import homeostatic.platform.Services;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class TemperatureData {
    public float localTemperature;
    public float skinTemperature;
    public float coreTemperature;
    public static final ResourceLocation ID = Homeostatic.prefix("temperature_data");

    public TemperatureData(float localTemperature, float skinTemperature, float coreTemperature) {
        this.localTemperature = localTemperature;
        this.skinTemperature = skinTemperature;
        this.coreTemperature = coreTemperature;
    }

    public TemperatureData(FriendlyByteBuf buf) {
        this.localTemperature = buf.readFloat();
        this.skinTemperature = buf.readFloat();
        this.coreTemperature = buf.readFloat();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeFloat(this.localTemperature);
        buf.writeFloat(this.skinTemperature);
        buf.writeFloat(this.coreTemperature);
    }

    public static void process(Player player, CompoundTag tag) {
        Services.PLATFORM.getTemperatureData(player).ifPresent(data -> data.read(tag));
    }

    public String toString() {
        return "local: " + this.localTemperature + " skin: " + this.skinTemperature + " core: " + this.coreTemperature;
    }
}

