/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.platform;

import homeostatic.common.attachments.TemperatureData;
import homeostatic.common.attachments.ThermometerData;
import homeostatic.common.attachments.WaterData;
import homeostatic.common.attachments.WetnessData;
import homeostatic.common.biome.ClimateSettings;
import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.item.IItemStackFluid;
import homeostatic.common.item.LeatherFlask;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.EnvironmentData;
import homeostatic.common.temperature.SubSeason;
import homeostatic.common.temperature.ThermometerInfo;
import homeostatic.common.water.WaterInfo;
import homeostatic.common.wetness.WetnessInfo;
import homeostatic.mixin.ServerLevelAccessor;
import homeostatic.network.ITemperature;
import homeostatic.network.IThermometer;
import homeostatic.network.IWater;
import homeostatic.network.IWetness;
import homeostatic.network.NeoForgeTemperatureData;
import homeostatic.network.NeoForgeThermometerData;
import homeostatic.network.NeoForgeWaterData;
import homeostatic.network.NeoForgeWetnessData;
import homeostatic.platform.services.IPlatform;
import homeostatic.registries.HomeostaticNeoForgeRegistries;
import homeostatic.util.CreateHelper;
import homeostatic.util.ItemStackFluidHelper;
import homeostatic.util.SereneSeasonsForgeHelper;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;
import technology.roughness.whitenoise.platform.Services;

public class NeoForgePlatform
implements IPlatform {
    @Override
    public ResourceLocation getFluidResourceLocation(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid);
    }

    @Override
    public double getCreateBlockRadiation(BlockState state, Double radiation) {
        return CreateHelper.getBlockRadiation(state, radiation);
    }

    @Override
    public String fluidStackTag() {
        return "Fluid";
    }

    @Override
    public Optional<FluidInfo> getFluidInfo(ItemStack stack) {
        if (stack.getItem() instanceof IItemStackFluid) {
            return Optional.of(ItemStackFluidHelper.getFluidInfo(stack));
        }
        return Optional.empty();
    }

    @Override
    public ItemStack drainFluid(ItemStack stack, long amount) {
        if (stack.getItem() instanceof IItemStackFluid) {
            ItemStackFluidHelper.drainFluid(stack, amount);
        }
        return stack;
    }

    @Override
    public ItemStack fillFluid(ItemStack stack, Fluid fluid, long amount) {
        if (stack.getItem() instanceof IItemStackFluid) {
            ItemStackFluidHelper.fillFluid(stack, fluid, amount);
        }
        return stack;
    }

    @Override
    public long getFluidCapacity(ItemStack stack) {
        if (stack.getItem() instanceof LeatherFlask) {
            return 1000L;
        }
        return 0L;
    }

    @Override
    public Component getDisplayName(Fluid fluid) {
        FluidInfo fluidInfo = new FluidInfo(fluid);
        return fluid.getFluidType().getDescription(new FluidStack(fluidInfo.fluid(), (int)fluidInfo.amount()));
    }

    @Override
    public ClimateSettings getClimateSettings(Holder<Biome> biomeHolder) {
        Biome.ClimateSettings climateSettings = ((Biome)biomeHolder.value()).getModifiedClimateSettings();
        return new ClimateSettings(biomeHolder, climateSettings.hasPrecipitation(), climateSettings.temperature(), climateSettings.temperatureModifier(), climateSettings.downfall());
    }

    @Override
    public SubSeason getSubSeason(ServerLevel level, Holder<Biome> biomeHolder) {
        if (Services.PLATFORM.isModLoaded("sereneseasons") && SereneSeasonsForgeHelper.isSeasonDimension((Level)level)) {
            return SereneSeasonsForgeHelper.getSubSeason((Level)level);
        }
        return null;
    }

    @Override
    public Optional<? extends ITemperature> getTemperatureData(Player player) {
        return TemperatureData.getData(player);
    }

    @Override
    public void syncTemperatureData(ServerPlayer sp, EnvironmentData environmentData, BodyTemperature bodyTemperature) {
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new NeoForgeTemperatureData(environmentData.getLocalTemperature(), bodyTemperature), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public Optional<? extends IThermometer> getThermometerCapability(Player player) {
        return ThermometerData.getData(player);
    }

    @Override
    public void syncThermometerData(ServerPlayer sp, ThermometerInfo info) {
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new NeoForgeThermometerData(info), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public Optional<? extends IWater> getWaterCapabilty(Player player) {
        return WaterData.getData(player);
    }

    @Override
    public void syncWaterData(ServerPlayer sp, WaterInfo waterInfo) {
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new NeoForgeWaterData(waterInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public Optional<? extends IWetness> getWetnessCapability(Player player) {
        return WetnessData.getData(player);
    }

    @Override
    public void syncWetnessData(ServerPlayer sp, WetnessInfo wetnessInfo) {
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new NeoForgeWetnessData(wetnessInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public ServerLevelData getServerLevelData(ServerLevel level) {
        ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
        return serverLevel.getServerLevelData();
    }

    @Override
    public <T> void registerDataComponent(ResourceLocation name, DataComponentType<T> component) {
        HomeostaticNeoForgeRegistries.COMPONENT_TYPE_DEFERRED_REGISTER.register(name.getPath(), () -> component);
    }

    @Override
    public boolean isVampire(Player player) {
        return false;
    }
}

