/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.biome;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.biome.Biome;

public class BiomeTypeData {
    public static final float FROZEN_OFFSET = -0.31f;
    public static final float SNOW_OFFSET = -0.446f;
    public static final float MC_DEGREE = 0.022289157f;
    private final float temperature;
    private double humidity;
    private final double seasonVariation;
    private final double dayNightOffset;
    private final boolean isFrozen;

    public BiomeTypeData(float temperature, double humidity, double seasonVariation, double dayNightOffset, boolean isFrozen) {
        this.temperature = temperature;
        this.humidity = humidity;
        this.seasonVariation = seasonVariation;
        this.dayNightOffset = dayNightOffset;
        this.isFrozen = isFrozen;
    }

    public float getTemperature(Biome.Precipitation precipitation) {
        float temperature = this.temperature;
        if (this.isFrozen) {
            temperature += -0.31f;
        }
        if (precipitation == Biome.Precipitation.SNOW) {
            temperature += -0.446f;
        }
        return temperature;
    }

    public double getHumidity(Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.SNOW) {
            this.humidity = 20.0;
        }
        return this.humidity;
    }

    public float getSeasonVariation(Biome.Precipitation precipitation) {
        float seasonVariation = (float)this.seasonVariation * 0.022289157f;
        if (precipitation == Biome.Precipitation.SNOW) {
            return seasonVariation / 2.0f;
        }
        return seasonVariation;
    }

    public float getDayNightOffset(Biome.Precipitation precipitation) {
        float dayNightOffset = (float)this.dayNightOffset * 0.022289157f;
        if (precipitation == Biome.Precipitation.SNOW) {
            return dayNightOffset / 2.0f;
        }
        return dayNightOffset;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public String toString() {
        return "BiomeData{temperature=" + this.temperature + ", humidity=" + this.humidity + ", seasonVariation=" + this.seasonVariation + ", dayNightOffset=" + this.dayNightOffset + "}";
    }

    public static class Serializer
    implements JsonDeserializer<BiomeTypeData>,
    JsonSerializer<BiomeTypeData> {
        public BiomeTypeData deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"data");
            return new BiomeTypeData(GsonHelper.m_13915_((JsonObject)json, (String)"temperature"), GsonHelper.m_144784_((JsonObject)json, (String)"humidity"), GsonHelper.m_144784_((JsonObject)json, (String)"season_variation"), GsonHelper.m_144784_((JsonObject)json, (String)"day_night_offset"), GsonHelper.m_13912_((JsonObject)json, (String)"is_frozen"));
        }

        public JsonElement serialize(BiomeTypeData biomeTypeData, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("temperature", (Number)Float.valueOf(biomeTypeData.temperature));
            json.addProperty("humidity", (Number)biomeTypeData.humidity);
            json.addProperty("season_variation", (Number)biomeTypeData.seasonVariation);
            json.addProperty("day_night_offset", (Number)biomeTypeData.dayNightOffset);
            json.addProperty("is_frozen", Boolean.valueOf(biomeTypeData.isFrozen));
            return json;
        }
    }
}

