/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.recipe;

import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.WaterContainerItem;
import homeostatic.platform.Services;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluids;

public interface IWaterContainerCookingRecipe {
    default public ItemStack assemble(Container container, ItemStack result) {
        ItemStack filledFlask = result.m_41777_();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack ingredient = container.m_8020_(i);
            if (!(ingredient.m_41720_() instanceof WaterContainerItem)) continue;
            FluidInfo fluidInfo = Services.PLATFORM.getFluidInfo(ingredient).get();
            int amount = (int)fluidInfo.amount();
            Services.PLATFORM.fillFluid(filledFlask, HomeostaticFluids.PURIFIED_WATER, amount);
        }
        return filledFlask;
    }

    default public boolean matches(Container container, Long minimumFluid) {
        if (container.m_8020_(0).m_41720_() instanceof WaterContainerItem) {
            FluidInfo fluidInfo = Services.PLATFORM.getFluidInfo(container.m_8020_(0)).get();
            return fluidInfo.amount() >= minimumFluid && fluidInfo.fluid() == Fluids.f_76193_;
        }
        return false;
    }

    default public ItemStack getCleanWaterFilledLWaterContainer(ItemStack original) {
        ItemStack filledStack = original.m_41777_();
        Services.PLATFORM.fillFluid(filledStack, HomeostaticFluids.PURIFIED_WATER, Services.PLATFORM.getFluidCapacity(filledStack));
        return filledStack;
    }
}

