/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.recipe;

import com.mojang.datafixers.util.Pair;
import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.item.LeatherFlask;
import homeostatic.common.recipe.HomeostaticRecipes;
import homeostatic.platform.Services;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class PurifiedLeatherFlask
extends CustomRecipe {
    public PurifiedLeatherFlask(ResourceLocation loc, CraftingBookCategory category) {
        super(loc, category);
    }

    public boolean matches(CraftingContainer pContainer, Level pLevel) {
        Pair<ItemStack, ItemStack> check = this.checkContainer(pContainer);
        ItemStack flask = (ItemStack)check.getFirst();
        ItemStack filter = (ItemStack)check.getSecond();
        return flask != null && filter != null;
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess registryAccess) {
        Pair<ItemStack, ItemStack> check = this.checkContainer(pContainer);
        ItemStack flaskCopy = ((ItemStack)check.getFirst()).m_41777_();
        FluidInfo fluidInfo = Services.PLATFORM.getFluidInfo(flaskCopy).get();
        int amount = (int)fluidInfo.amount();
        Services.PLATFORM.drainFluid(flaskCopy, amount);
        return Services.PLATFORM.fillFluid(flaskCopy, HomeostaticFluids.PURIFIED_WATER, amount);
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return HomeostaticRecipes.PURIFIED_LEATHER_FLASK_SERIALIZER;
    }

    public Pair<ItemStack, ItemStack> checkContainer(CraftingContainer pContainer) {
        ItemStack flask = null;
        ItemStack filter = null;
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            FluidInfo fluidInfo;
            ItemStack ingredient = pContainer.m_8020_(i);
            if (ingredient.m_150930_(HomeostaticItems.WATER_FILTER)) {
                filter = ingredient;
                continue;
            }
            if (!(ingredient.m_41720_() instanceof LeatherFlask) || (fluidInfo = Services.PLATFORM.getFluidInfo(ingredient).get()).amount() <= 0L) continue;
            flask = ingredient;
        }
        return Pair.of(flask, filter);
    }

    public static class Type
    implements RecipeType<PurifiedLeatherFlask> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

