/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.event;

import homeostatic.common.capabilities.ITemperature;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.EnvironmentData;
import homeostatic.common.temperature.ThermometerInfo;
import homeostatic.common.water.WaterInfo;
import homeostatic.config.ConfigHandler;
import homeostatic.platform.Services;
import homeostatic.util.WaterHelper;
import homeostatic.util.WetnessHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;

public class PlayerEventHandler {
    public static void onEntityJoinLevel(ServerPlayer sp) {
        ServerLevel world = sp.m_284548_();
        if (sp.f_8941_.m_9290_() != GameType.SURVIVAL) {
            return;
        }
        WaterHelper.updateWaterInfo(sp, 0.0f);
        WetnessHelper.updateWetnessInfo(sp, 0.0f, true);
        Services.PLATFORM.getTemperatureData((Player)sp).ifPresent(data -> {
            Vec3 spPos = sp.m_20299_(1.0f);
            BlockPos pos = new BlockPos((int)spPos.m_7096_(), (int)spPos.m_7098_(), (int)spPos.m_7094_());
            Holder biome = world.m_204166_(pos);
            EnvironmentData environmentData = new EnvironmentData(sp, pos, (Holder<Biome>)biome, world);
            BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, (ITemperature)data);
            Services.PLATFORM.syncTemperatureData(sp, environmentData, bodyTemperature);
        });
    }

    public static void onPlayerTickEvent(ServerPlayer sp) {
        if (sp.f_8941_.m_9290_() != GameType.SURVIVAL) {
            return;
        }
        ServerLevel world = sp.m_284548_();
        ProfilerFiller profilerfiller = world.m_46473_();
        Services.PLATFORM.getWaterCapabilty((Player)sp).ifPresent(data -> data.checkWaterLevel(sp));
        profilerfiller.m_6180_("tempCalc");
        Services.PLATFORM.getTemperatureData((Player)sp).ifPresent(data -> {
            if (sp.f_19797_ % 2 == 0) {
                data.checkTemperatureLevel((Player)sp);
            }
            if (sp.f_19797_ % 16 == 0 || sp.f_19797_ % 60 == 0) {
                Vec3 spPos = sp.m_20299_(1.0f);
                BlockPos pos = new BlockPos((int)spPos.m_7096_(), (int)spPos.m_7098_(), (int)spPos.m_7094_());
                Holder biome = world.m_204166_(pos);
                EnvironmentData environmentData = new EnvironmentData(sp, pos, (Holder<Biome>)biome, world);
                boolean updateCore = sp.f_19797_ % 60 == 0;
                BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, (ITemperature)data, updateCore, true);
                data.setTemperatureData(environmentData.getLocalTemperature(), bodyTemperature);
                Services.PLATFORM.syncTemperatureData(sp, environmentData, bodyTemperature);
            }
        });
        profilerfiller.m_7238_();
    }

    public static void onPlayerRespawn(ServerPlayer sp) {
        ServerLevel world = sp.m_284548_();
        if (sp.f_8941_.m_9290_() != GameType.SURVIVAL) {
            return;
        }
        Services.PLATFORM.getWaterCapabilty((Player)sp).ifPresent(data -> {
            WaterInfo waterInfo = new WaterInfo(10, 2.5f, 0.0f);
            data.setWaterData(waterInfo);
            Services.PLATFORM.syncWaterData(sp, waterInfo);
        });
        Services.PLATFORM.getTemperatureData((Player)sp).ifPresent(data -> {
            Vec3 spPos = sp.m_20299_(1.0f);
            BlockPos pos = new BlockPos((int)spPos.m_7096_(), (int)spPos.m_7098_(), (int)spPos.m_7094_());
            Holder biome = world.m_204166_(pos);
            EnvironmentData environmentData = new EnvironmentData(sp, pos, (Holder<Biome>)biome, world);
            BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, (ITemperature)data);
            data.setTemperatureData(environmentData.getLocalTemperature(), bodyTemperature);
            Services.PLATFORM.syncTemperatureData(sp, environmentData, bodyTemperature);
        });
    }

    public static void onEquipmentChange(LivingEntity entity, EquipmentSlot slot, ItemStack previousItem, ItemStack equippedItem) {
        if (ConfigHandler.Common.showTemperatureValues() && ConfigHandler.Common.requireThermometer() && slot == EquipmentSlot.HEAD && entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_9236_().f_46443_) {
                ServerPlayer sp = (ServerPlayer)player;
                Services.PLATFORM.getThermometerCapability((Player)sp).ifPresent(data -> {
                    boolean equippedHasThermometer = PlayerEventHandler.hasThermometer(equippedItem);
                    ThermometerInfo info = new ThermometerInfo(equippedHasThermometer);
                    Services.PLATFORM.syncThermometerData(sp, info);
                });
            }
        }
    }

    private static boolean hasThermometer(ItemStack helmet) {
        CompoundTag tag = helmet.m_41784_();
        return tag.m_128441_("thermometer");
    }
}

