/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.water;

public class WaterInfo {
    public static final int MAX_WATER_LEVEL = 20;
    public static final float MAX_SATURATION_LEVEL = 5.0f;
    private int waterLevel;
    private float waterSaturationLevel;
    private float waterExhaustionLevel;

    public WaterInfo(int waterLevel, float waterSaturationLevel, float waterExhaustionLevel) {
        this.waterLevel = waterLevel;
        this.waterSaturationLevel = waterSaturationLevel;
        this.waterExhaustionLevel = waterExhaustionLevel;
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public float getWaterExhaustionLevel() {
        return this.waterExhaustionLevel;
    }

    public float getWaterSaturationLevel() {
        return this.waterSaturationLevel;
    }

    public void update(float sweatLevel) {
        if (this.waterExhaustionLevel > 4.0f) {
            this.waterExhaustionLevel -= 4.0f;
            if (this.waterSaturationLevel > 0.0f) {
                this.waterSaturationLevel = Math.max(this.waterSaturationLevel - 1.0f, 0.0f);
            } else {
                this.waterLevel = Math.max(this.waterLevel - 1, 0);
            }
        }
        if (sweatLevel > 0.0f) {
            this.addExhaustion(sweatLevel);
        }
    }

    public void addExhaustion(float amount) {
        this.waterExhaustionLevel += amount;
    }
}

